/*
 * Decompiled with CFR 0.152.
 */
package ch.sf.htt;

import ch.sf.htt.ITestListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class TestReportListener
implements ITestListener {
    private BufferedWriter reportWriter;
    private String error = "";

    public TestReportListener(String pathToReport) throws IOException {
        File report = new File(pathToReport);
        report.getParentFile().mkdirs();
        report.createNewFile();
        report.setWritable(true, true);
        FileWriter fw = new FileWriter(report.getAbsoluteFile());
        this.reportWriter = new BufferedWriter(fw);
    }

    @Override
    public void addStandardOutput(String text) {
        try {
            this.reportWriter.write(text);
            this.reportWriter.append('\n');
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void addErrorOutput(String text) {
        this.error = this.error + text + '\n';
    }

    @Override
    public void setState(ITestListener.STATE state) {
        try {
            if (state == ITestListener.STATE.FAILED) {
                this.reportWriter.flush();
            }
            if (state != ITestListener.STATE.RUNNING) {
                this.reportWriter.write(this.error);
                this.reportWriter.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

