/*
 * Decompiled with CFR 0.152.
 */
package ch.sf.htt;

import ch.sf.htt.OperatingSystem;

public enum Architecture {
    UNKNOWN,
    X86,
    X86_64,
    SPARC;


    public static Architecture get() {
        if (OperatingSystem.get() == OperatingSystem.WINDOWS) {
            return X86;
        }
        String arch = System.getProperty("os.arch").toLowerCase();
        String vm = System.getProperty("java.vm.name").toLowerCase();
        if (arch.equals("amd64") || arch.equals("x86_64") || vm.contains("64-bit")) {
            return X86_64;
        }
        if (arch.equals("x86") || arch.equals("i386") || arch.equals("i686")) {
            return X86;
        }
        if (arch.contains("sparc")) {
            return SPARC;
        }
        return UNKNOWN;
    }
}

