/*
 * Decompiled with CFR 0.152.
 */
package ch.sf.htt;

import ch.sf.htt.ITestListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class ProcessStreamHandler
extends Thread {
    private InputStream inputStream;
    private String streamType = "<undefined>";
    private boolean completed = false;
    private List<String> text = null;
    private boolean verbose = false;
    private boolean interrupted = false;
    private boolean isError = false;
    private ITestListener listener = null;

    public ProcessStreamHandler(InputStream inputStream, String streamType, ITestListener listener) {
        this.inputStream = inputStream;
        this.streamType = streamType;
        this.listener = listener;
    }

    public ProcessStreamHandler(InputStream inputStream, String streamType) {
        this.inputStream = inputStream;
        this.streamType = streamType;
    }

    @Override
    public void interrupt() {
        this.interrupted = true;
    }

    public void setVerbose(boolean value) {
        this.verbose = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.text = new ArrayList<String>();
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (this.verbose) {
                    System.out.println(">>" + this.streamType + ": " + line);
                }
                if (this.listener != null) {
                    if (this.isError) {
                        this.listener.addErrorOutput(line);
                    } else {
                        this.listener.addStandardOutput(line);
                    }
                }
                this.text.add(line);
            }
            reader.close();
        }
        catch (Exception e) {
            if (!this.interrupted) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {}
            this.completed = true;
        }
    }

    public List<String> getText() {
        return this.text;
    }

    public boolean hasCompleted() {
        return this.completed;
    }
}

