/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.jaxbPlugins.nonNullGetter;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.model.Aspect;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.List;
import java.util.Map;
import org.xml.sax.ErrorHandler;

public class XjcNonNullGetterPlugin
extends Plugin {
    public String getOptionName() {
        return "XNonNullGetter-api";
    }

    public String getUsage() {
        return "  -XNonNullGetter-api        :  non null getter api for generated code";
    }

    public boolean run(Outline aOutline, Options opt, ErrorHandler errorHandler) {
        for (ClassOutline classOutline : aOutline.getClasses()) {
            CClassInfo classInfo = classOutline.target;
            this.treatOneClass(aOutline, classInfo);
        }
        return true;
    }

    private void treatOneClass(Outline aOutline, CClassInfo aClassInfo) {
        JClass implClass = aClassInfo.toType(aOutline, Aspect.IMPLEMENTATION);
        if (null == implClass) {
            throw new NullPointerException("Classe d'impl\u00e9mentation inconnue pour " + aClassInfo.getName());
        }
        if (!(implClass instanceof JDefinedClass)) {
            throw new NullPointerException("N'est pas une JDefinedClass " + aClassInfo.getName());
        }
        this.treatOneClass(aOutline, (JDefinedClass)implClass);
    }

    private void treatOneClass(Outline aOutline, JDefinedClass aClass) {
        for (Map.Entry entry : aClass.fields().entrySet()) {
            String fieldName = (String)entry.getKey();
            JFieldVar field = (JFieldVar)entry.getValue();
            JType type = field.type();
            boolean isList = false;
            if (!(type instanceof JClass)) continue;
            JClass jclass = (JClass)JClass.class.cast(type);
            List typeParams = jclass.getTypeParameters();
            if (typeParams.size() == 1) {
                jclass = (JClass)typeParams.get(0);
                isList = true;
            }
            boolean isGeneratedType = false;
            if (!(jclass instanceof JDefinedClass) || ClassType.ENUM == ((JDefinedClass)jclass).getClassType()) continue;
            for (JClass outerClass = jclass; !isGeneratedType && null != outerClass; outerClass = outerClass.outer()) {
                String typeFullName = outerClass.fullName();
                isGeneratedType = null != aOutline.getCodeModel()._getClass(typeFullName);
            }
            if (!isGeneratedType) continue;
            if (isList) {
                this.treatListField(aClass, fieldName, field, (JType)jclass);
                continue;
            }
            this.treatSimpleField(aClass, fieldName, field);
        }
    }

    private void treatSimpleField(JDefinedClass aImplClass, String aFieldName, JFieldVar aField) {
        JMethod nonNullGetterMethod = aImplClass.method(1, aField.type(), aFieldName);
        JBlock jblock = nonNullGetterMethod.body();
        jblock._if(JExpr._null().eq((JExpression)JExpr.refthis((String)aFieldName)))._then().assign((JAssignmentTarget)JExpr.refthis((String)aFieldName), (JExpression)JExpr._new((JType)aField.type()));
        jblock._return((JExpression)JExpr.refthis((String)aFieldName));
    }

    private void treatListField(JDefinedClass aImplClass, String aFieldName, JFieldVar aField, JType aType) {
        StringBuffer getterMethodName = new StringBuffer("get");
        getterMethodName.append(aFieldName.substring(0, 1).toUpperCase());
        getterMethodName.append(aFieldName.substring(1));
        JMethod nonNullGetterMethod = aImplClass.method(1, aType, aFieldName);
        JBlock jblock = nonNullGetterMethod.body();
        JVar newEl = jblock.decl(aType, "newElement", (JExpression)JExpr._new((JType)aType));
        jblock.directStatement(getterMethodName + "().add(newElement);");
        jblock._return((JExpression)newEl);
    }
}

