/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.action;

import ch.sharedvd.tipi.engine.action.Activity;
import ch.sharedvd.tipi.engine.client.VariableMap;
import ch.sharedvd.tipi.engine.command.MetaModelHelper;
import ch.sharedvd.tipi.engine.meta.ActivityMetaModel;
import ch.sharedvd.tipi.engine.model.ActivityState;
import ch.sharedvd.tipi.engine.model.DbActivity;
import ch.sharedvd.tipi.engine.model.DbSubProcess;
import ch.sharedvd.tipi.engine.model.DbTopProcess;
import ch.sharedvd.tipi.engine.svc.ActivityPersisterService;
import ch.sharedvd.tipi.engine.utils.Assert;
import java.io.Serializable;
import java.util.List;

public class ActivityFacade {
    private ActivityPersisterService activityPersisterService;
    private long activityId;

    public ActivityFacade(long activityId, ActivityPersisterService manager) {
        Assert.notNull((Object)activityId);
        Assert.notNull((Object)manager);
        this.activityId = activityId;
        this.activityPersisterService = manager;
    }

    public long getId() {
        return this.getModel().getId();
    }

    public String getName() {
        return this.getModel().getFqn();
    }

    public Object getVariable(String key) {
        return this.getVariable(this.getModel(), key);
    }

    public Object getVariable(long id, String key) {
        DbActivity m = this.activityPersisterService.getModel(id);
        return this.getVariable(m, key);
    }

    public List<ActivityFacade> getChildren() {
        return this.activityPersisterService.getChildren(this.getModel().getId());
    }

    public void putVariable(String key, Serializable value) {
        this.activityPersisterService.putVariable(this.activityPersisterService.getModel(this.activityId), key, value);
    }

    public long addChildActivity(ActivityMetaModel meta, Long previousId, VariableMap vars) {
        DbSubProcess parent = (DbSubProcess)this.getModel();
        return this.activityPersisterService.addChildActivity(meta, parent, previousId, vars, null);
    }

    public long addChildActivity(Class<? extends Activity> clazz, Long previousId, VariableMap vars) {
        DbSubProcess parent = (DbSubProcess)this.getModel();
        return this.activityPersisterService.addChildActivity(MetaModelHelper.getActivityMetaModel(clazz), parent, previousId, vars, null);
    }

    public long addChildActivity(Class<? extends Activity> clazz, Long previousId, VariableMap vars, String correlationId) {
        DbSubProcess parent = (DbSubProcess)this.getModel();
        ActivityMetaModel meta = MetaModelHelper.getActivityMetaModel(clazz);
        return this.activityPersisterService.addChildActivity(meta, parent, previousId, vars, correlationId);
    }

    public boolean isAborted() {
        DbActivity m = this.getModel();
        DbTopProcess p = m.getProcess() != null ? m.getProcess() : (DbTopProcess)m;
        Assert.notNull((Object)p);
        ActivityState dbState = this.activityPersisterService.getDbActivityState(p.getId());
        return dbState == ActivityState.ABORTED;
    }

    private DbActivity getModel() {
        return this.activityPersisterService.getModel(this.activityId);
    }

    private Object getVariable(DbActivity m, String key) {
        Object o = m.getVariable(key);
        if (o == null && m.getPrevious() != null) {
            o = m.getPrevious().getVariable(key);
        }
        if (o == null) {
            o = this.getVariableFromParent(m.getParent(), key);
        }
        return o;
    }

    private Object getVariableFromParent(DbActivity parent, String key) {
        if (parent != null) {
            Object o = parent.getVariable(key);
            if (o == null) {
                return this.getVariableFromParent(parent.getParent(), key);
            }
            return o;
        }
        return null;
    }
}

