/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.command;

import ch.sharedvd.tipi.engine.command.CommandHelperService;
import ch.sharedvd.tipi.engine.command.CommandService;
import ch.sharedvd.tipi.engine.command.MetaModelHelper;
import ch.sharedvd.tipi.engine.meta.ActivityMetaModel;
import ch.sharedvd.tipi.engine.meta.TopProcessMetaModel;
import ch.sharedvd.tipi.engine.model.ActivityState;
import ch.sharedvd.tipi.engine.model.DbActivity;
import ch.sharedvd.tipi.engine.repository.ActivityRepository;
import ch.sharedvd.tipi.engine.runner.ActivityRunner;
import ch.sharedvd.tipi.engine.runner.ActivityRunnerContext;
import ch.sharedvd.tipi.engine.runner.ActivityRunningService;
import ch.sharedvd.tipi.engine.runner.ConnectionCapManager;
import ch.sharedvd.tipi.engine.runner.TopProcessGroupLauncher;
import ch.sharedvd.tipi.engine.runner.TopProcessGroupManager;
import ch.sharedvd.tipi.engine.utils.Assert;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;

public abstract class Command {
    private static final Logger LOGGER = LoggerFactory.getLogger(Command.class);
    @Autowired
    protected ActivityRepository activityRepository;
    @Autowired
    protected PlatformTransactionManager txManager;
    @Autowired
    protected EntityManager em;
    @Autowired
    protected TopProcessGroupManager groupManager;
    @Autowired
    protected ConnectionCapManager connectionCapManager;
    @Autowired
    protected CommandService commandService;
    @Autowired
    protected CommandHelperService commandHelperService;
    @Autowired
    protected ActivityRunningService activityService;

    public abstract void execute();

    protected TopProcessGroupLauncher getLauncher(TopProcessMetaModel topProcess) {
        TopProcessGroupLauncher launcher = this.groupManager.getLauncher(topProcess);
        return launcher;
    }

    protected boolean runActivity(DbActivity acti) {
        ActivityMetaModel meta = MetaModelHelper.getMeta(acti.getFqn());
        TopProcessMetaModel group = MetaModelHelper.getTopProcessMeta(acti.getProcessOrThis().getFqn());
        return this.runActivity(acti, meta, group);
    }

    protected boolean runActivity(DbActivity aActivity, ActivityMetaModel meta, TopProcessMetaModel topProcess) {
        boolean wasRun = false;
        long id = aActivity.getId();
        boolean debugEnabled = LOGGER.isDebugEnabled();
        boolean traceEnabled = LOGGER.isTraceEnabled();
        TopProcessGroupManager.RunReason reason = this.groupManager.hasRoom(topProcess);
        if (reason == TopProcessGroupManager.RunReason.OK) {
            if (this.connectionCapManager.hasConnections(meta)) {
                TopProcessGroupLauncher launcher = this.getLauncher(topProcess);
                if (!launcher.isRunning(id)) {
                    Assert.isEqual((Object)ActivityState.EXECUTING, (Object)aActivity.getState());
                    ActivityRunner runner = new ActivityRunner(this.getContext(topProcess), id, meta);
                    launcher.startNewThread(runner);
                    wasRun = true;
                    if (debugEnabled) {
                        LOGGER.debug("Activity " + id + " started");
                    }
                } else if (debugEnabled) {
                    LOGGER.debug("Activity " + id + " already running");
                }
            } else if (traceEnabled) {
                LOGGER.trace("L'activit\u00e9 " + id + " ne peut pas \u00eatre d\u00e9marr\u00e9e parce que toutes les connections sont occup\u00e9es");
            }
        } else if (reason == TopProcessGroupManager.RunReason.NO_TOP_ROOM) {
            if (debugEnabled) {
                String message = "Le top-process " + id + " ne peut pas \u00eatre d\u00e9marr\u00e9 car le nombre maximal de top-process est atteint dans le groupe " + topProcess.getFQN();
                LOGGER.debug(message);
            }
        } else if (reason == TopProcessGroupManager.RunReason.NO_ROOM) {
            if (debugEnabled) {
                LOGGER.debug("L'activit\u00e9 " + id + " ne peut pas \u00eatre d\u00e9marr\u00e9e parce que plus de place dans le groupe " + topProcess.getFQN());
            }
        } else if (reason == TopProcessGroupManager.RunReason.EXCLUSIVE && debugEnabled) {
            LOGGER.debug("L'activit\u00e9 " + id + " ne peut pas \u00eatre d\u00e9marr\u00e9e parce qu'un groupe exclusif tourne deja");
        }
        return wasRun;
    }

    public boolean needTransaction() {
        return true;
    }

    public String toString() {
        return "Cmd: " + this.getClass().getSimpleName();
    }

    private ActivityRunnerContext getContext(TopProcessMetaModel topProcess) {
        return new ActivityRunnerContext(this.activityRepository, this.commandHelperService, this.commandService, this.groupManager, this.txManager, this.getLauncher(topProcess));
    }

    public void setActivityRepository(ActivityRepository activityRepository) {
        this.activityRepository = activityRepository;
    }

    public int getPriority() {
        return 100;
    }

    public boolean isRemoveSameCommands() {
        return false;
    }
}

