/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.command;

import ch.sharedvd.tipi.engine.command.Command;
import ch.sharedvd.tipi.engine.command.CommandWrapper;
import ch.sharedvd.tipi.engine.command.impl.ColdRestartCommand;
import ch.sharedvd.tipi.engine.command.impl.RunExecutingActivitiesCommand;
import ch.sharedvd.tipi.engine.command.impl.StopConsumerCommand;
import ch.sharedvd.tipi.engine.utils.BeanAutowirer;
import ch.sharedvd.tipi.engine.utils.QuantityFormatter;
import ch.sharedvd.tipi.engine.utils.Startable;
import ch.sharedvd.tipi.engine.utils.TixTemplate;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class CommandConsumer
implements Startable,
Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandConsumer.class);
    @Autowired
    private BeanAutowirer autowirer;
    @Autowired
    private TixTemplate tt;
    private boolean resumeTipiAtBoot = true;
    private boolean commandEnCours = false;
    private BlockingQueue<CommandWrapper> queue;
    private Thread consumationThread;
    private boolean stopped = true;

    @Override
    public void start() throws Exception {
        LOGGER.info("Start called");
        Assert.isTrue((boolean)this.stopped);
        this.stopped = false;
        this.queue = new ArrayBlockingQueue<CommandWrapper>(100000);
        this.consumationThread = new Thread(this);
        this.consumationThread.setName("TiPi-Consumer");
        this.consumationThread.setPriority(6);
        LOGGER.info("D\u00e9marrage du Thread de CommandConsumer ...");
        this.consumationThread.start();
        if (this.resumeTipiAtBoot) {
            LOGGER.info("Cold restart TiPi ...");
            this.addCommand(new ColdRestartCommand());
        } else {
            LOGGER.info("Pas de Cold restart de TiPi");
        }
    }

    @Override
    public void stop() {
        this.stopped = true;
    }

    @Override
    public void destroy() throws Exception {
        this.destroy(false);
    }

    public void destroy(boolean calledFromStart) throws Exception {
        if (!this.stopped) {
            if (calledFromStart) {
                LOGGER.info("Destroy called from Start");
            } else {
                LOGGER.info("Destroy called");
            }
        }
        this.stopped = true;
        if (this.consumationThread != null) {
            this.addCommand(new StopConsumerCommand());
            this.queue = null;
            for (int cnt = 0; this.consumationThread != null && cnt < 50; ++cnt) {
                if (cnt == 2) {
                    LOGGER.debug("Waiting for the thread to stop (max 5 sec) ...");
                }
                Thread.sleep(100L);
            }
            if (this.consumationThread != null && this.consumationThread.isAlive() && !this.consumationThread.isInterrupted()) {
                LOGGER.info("Thread not stopped by itself. Interrupting ...");
                this.consumationThread.interrupt();
                this.consumationThread.join();
            }
            Assert.isNull((Object)this.consumationThread);
        }
        this.queue = null;
    }

    public int getPendingCommandCount() {
        if (this.queue != null) {
            return this.queue.size();
        }
        return 0;
    }

    public boolean hasCommandPending() {
        if (this.queue != null) {
            boolean has = this.queue.size() > 0 || this.commandEnCours;
            return has;
        }
        return this.commandEnCours;
    }

    public void removeCommandOfClass(Class<? extends Command> clazz) {
        this.removeCommandOfClass(clazz, false);
    }

    private void removeCommandOfClass(Class<? extends Command> clazz, boolean aNotTheFirst) {
        Assert.notNull(clazz);
        if (this.queue != null) {
            int count = 0;
            Iterator iter = this.queue.iterator();
            boolean first = aNotTheFirst;
            while (iter.hasNext()) {
                CommandWrapper c = (CommandWrapper)iter.next();
                if (c == null) continue;
                Assert.notNull((Object)c.getCommand());
                if (!clazz.isAssignableFrom(c.getCommand().getClass())) continue;
                if (!first) {
                    iter.remove();
                    ++count;
                }
                first = false;
            }
            if (count > 0) {
                LOGGER.debug("Suppression de " + count + " Command du type " + clazz.getSimpleName());
            }
        }
    }

    @Override
    public void run() {
        boolean loopActive = true;
        while (loopActive) {
            try {
                long begin;
                CommandWrapper currentCommand;
                block17: {
                    if (this.queue == null) {
                        loopActive = false;
                        continue;
                    }
                    this.commandEnCours = false;
                    currentCommand = this.queue.take();
                    Assert.notNull((Object)currentCommand, (String)"currentCommand can't ne null. Either a command or an InterruptedException");
                    this.commandEnCours = true;
                    if (currentCommand.getCommand() instanceof StopConsumerCommand) {
                        loopActive = false;
                        continue;
                    }
                    this.autowirer.autowire(currentCommand.getCommand());
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Begin command: " + currentCommand.getCommand());
                    }
                    if (currentCommand.getElapsedTimeMillis() > 10000L) {
                        LOGGER.warn("The command: " + currentCommand.getCommand() + " waited for " + QuantityFormatter.formatMillis(currentCommand.getElapsedTimeMillis()));
                    } else if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("The command: " + currentCommand.getCommand() + " waited for " + QuantityFormatter.formatMillis(currentCommand.getElapsedTimeMillis()));
                    }
                    begin = System.currentTimeMillis();
                    try {
                        if (currentCommand.getCommand().needTransaction()) {
                            this.tt.txWithout(status -> currentCommand.getCommand().execute());
                        } else {
                            currentCommand.getCommand().execute();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Exception pendant le traitement de la commande (retry=" + currentCommand.getNbRetry() + " command=" + currentCommand.getCommand() + ") : " + e, (Throwable)e);
                        if (currentCommand.getNbRetry() > 5) break block17;
                        currentCommand.incNbRetry();
                        this.queue.add(currentCommand);
                        Thread.sleep(2000L);
                    }
                }
                long diff = System.currentTimeMillis() - begin;
                if (diff > 3000L) {
                    LOGGER.warn("The command: " + currentCommand.getCommand() + " has taken " + QuantityFormatter.formatMillis(diff));
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("The command: " + currentCommand.getCommand() + " has taken " + QuantityFormatter.formatMillis(diff));
                }
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("End command: " + currentCommand.getCommand());
            }
            catch (InterruptedException inter) {
                Assert.isTrue((boolean)this.stopped);
                loopActive = false;
            }
            catch (Throwable e) {
                LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
                LOGGER.error(e.getMessage(), e);
            }
        }
        LOGGER.info("CommandConsumer thread (" + this.consumationThread.getName() + ") stopped");
        this.commandEnCours = false;
        this.consumationThread = null;
    }

    public void addCommand(Command c) {
        if (this.queue != null) {
            try {
                boolean result = this.queue.offer(new CommandWrapper(c), 10L, TimeUnit.SECONDS);
                if (result) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Ajout de '" + c + "' Nombre de commandes dans la queue apr\u00e8s: " + this.queue.size());
                    }
                } else {
                    LOGGER.error("Impossible d'ajouter la commande '" + c + "' dans la queue! Size=" + this.queue.size() + " Command=" + c.getClass().getSimpleName());
                    for (CommandWrapper w : this.queue) {
                        LOGGER.error(w.toString());
                    }
                }
                if (c instanceof RunExecutingActivitiesCommand) {
                    this.removeCommandOfClass(c.getClass(), true);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void setResumeTipiAtBoot(boolean startTipi) {
        this.resumeTipiAtBoot = startTipi;
    }
}

