/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.command;

import ch.sharedvd.tipi.engine.action.Activity;
import ch.sharedvd.tipi.engine.action.ActivityFacade;
import ch.sharedvd.tipi.engine.action.SubProcess;
import ch.sharedvd.tipi.engine.command.MetaModelHelper;
import ch.sharedvd.tipi.engine.meta.ActivityMetaModel;
import ch.sharedvd.tipi.engine.meta.SubProcessMetaModel;
import ch.sharedvd.tipi.engine.model.DbActivity;
import ch.sharedvd.tipi.engine.repository.ActivityRepository;
import ch.sharedvd.tipi.engine.svc.ActivityPersisterService;
import ch.sharedvd.tipi.engine.utils.Assert;
import ch.sharedvd.tipi.engine.utils.BeanAutowirer;
import org.springframework.beans.factory.annotation.Autowired;

public class CommandHelperService {
    @Autowired
    private BeanAutowirer autowirer;
    @Autowired
    private ActivityRepository activityRepository;
    @Autowired
    private ActivityPersisterService activityHelper;

    public Activity createActivity(long actId) {
        DbActivity model = (DbActivity)this.activityRepository.findOne(Long.valueOf(actId));
        return this.createActivity(model);
    }

    public Activity createActivity(DbActivity model) {
        ActivityMetaModel meta = MetaModelHelper.getMeta(model.getFqn());
        Activity act = meta.create();
        this.autowirer.autowire(act);
        act.setFacade(new ActivityFacade(model.getId(), this.activityHelper));
        this.verify(meta, act);
        return act;
    }

    private void verify(ActivityMetaModel meta, Activity act) {
        if (meta instanceof SubProcessMetaModel) {
            Assert.isTrue((boolean)(act instanceof SubProcess));
        }
    }
}

