/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.command;

import ch.sharedvd.tipi.engine.action.Activity;
import ch.sharedvd.tipi.engine.action.UnknownProcess;
import ch.sharedvd.tipi.engine.client.TipiActivity;
import ch.sharedvd.tipi.engine.client.TipiSubProcess;
import ch.sharedvd.tipi.engine.client.TipiTopProcess;
import ch.sharedvd.tipi.engine.client.TipiUnknownActivity;
import ch.sharedvd.tipi.engine.client.TipiVariable;
import ch.sharedvd.tipi.engine.client.VariableMap;
import ch.sharedvd.tipi.engine.meta.ActivityMetaModel;
import ch.sharedvd.tipi.engine.meta.SubProcessMetaModel;
import ch.sharedvd.tipi.engine.meta.TopProcessMetaModel;
import ch.sharedvd.tipi.engine.meta.VariableDescription;
import ch.sharedvd.tipi.engine.model.DbActivity;
import ch.sharedvd.tipi.engine.model.DbSubProcess;
import ch.sharedvd.tipi.engine.model.DbTopProcess;
import ch.sharedvd.tipi.engine.svc.ActivityPersisterService;
import ch.sharedvd.tipi.engine.utils.Assert;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaModelHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaModelHelper.class);

    public static DbActivity createModelFromMeta(ActivityMetaModel meta, boolean isProcess, VariableMap vars, ActivityPersisterService aHelperService) {
        Assert.notNull((Object)meta);
        DbActivity a = null;
        if (isProcess) {
            a = new DbTopProcess();
        } else if (meta instanceof SubProcessMetaModel) {
            a = new DbSubProcess();
        } else if (meta instanceof ActivityMetaModel) {
            a = new DbActivity();
        } else {
            Assert.fail("Activity type not supported");
        }
        a.setFqn(meta.getFQN());
        aHelperService.putVariables(a, vars);
        return a;
    }

    public static TopProcessMetaModel getTopProcessMeta(String fqn) {
        ActivityMetaModel amm = MetaModelHelper.getMeta(fqn);
        if (amm != null && amm instanceof TopProcessMetaModel) {
            return (TopProcessMetaModel)amm;
        }
        return null;
    }

    public static ActivityMetaModel getMeta(String fqn) {
        try {
            Class<?> activity = Class.forName(fqn);
            return MetaModelHelper.getActivityMetaModel(activity);
        }
        catch (ClassNotFoundException e) {
            Class<UnknownProcess> activity = UnknownProcess.class;
            return MetaModelHelper.getActivityMetaModel(activity);
        }
        catch (RuntimeException ee) {
            throw ee;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ActivityMetaModel getActivityMetaModel(Class<? extends Activity> clazz) {
        if (clazz.getAnnotation(TipiUnknownActivity.class) != null) {
            return MetaModelHelper.getUnkonwnProcessMetaModel(clazz);
        }
        if (clazz.getAnnotation(TipiTopProcess.class) != null) {
            return MetaModelHelper.getTopProcessMetaModel(clazz);
        }
        if (clazz.getAnnotation(TipiSubProcess.class) != null) {
            return MetaModelHelper.getSubProcessMetaModel(clazz);
        }
        if (clazz.getAnnotation(TipiActivity.class) != null) {
            return MetaModelHelper.getActivityMetaModelFromAnnotation(clazz);
        }
        return MetaModelHelper.getMetaFromStaticField(clazz);
    }

    @Deprecated
    public static ActivityMetaModel getMetaFromStaticField(Class<?> c) {
        try {
            Field field = c.getField("META");
            return (ActivityMetaModel)field.get(null);
        }
        catch (NoSuchFieldException ex) {
            try {
                Field field = c.getField("meta");
                return (ActivityMetaModel)field.get(null);
            }
            catch (SecurityException e) {
                LOGGER.error("Property meta for class " + c.getName() + " is not public");
            }
            catch (NoSuchFieldException e) {
                LOGGER.trace("No meta property for class" + c.getName());
            }
            catch (IllegalAccessException e) {
                LOGGER.trace("meta property for class" + c.getName() + " has no public access");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static TopProcessMetaModel getUnkonwnProcessMetaModel(Class<?> clazz) {
        TopProcessMetaModel metaModel = new TopProcessMetaModel(clazz, 1, 10, 10, "Unknown");
        metaModel.setShownInUI(true);
        return metaModel;
    }

    public static TopProcessMetaModel getTopProcessMetaModel(Class<?> clazz) {
        TipiTopProcess ann = clazz.getAnnotation(TipiTopProcess.class);
        List<VariableDescription> varsDesc = MetaModelHelper.getVariableDescriptions(ann);
        TopProcessMetaModel metaModel = new TopProcessMetaModel(clazz, ann.priority(), ann.nbMaxTopConcurrent(), ann.nbMaxConcurrent(), ann.description());
        metaModel.setDeleteWhenFinished(ann.deleteWhenFinished());
        metaModel.setStartable(ann.startable());
        metaModel.setVariablesDescription(varsDesc);
        metaModel.setShownInUI(ann.showInUi());
        return metaModel;
    }

    public static SubProcessMetaModel getSubProcessMetaModel(Class<?> clazz) {
        TipiSubProcess ann = clazz.getAnnotation(TipiSubProcess.class);
        SubProcessMetaModel metaModel = new SubProcessMetaModel(clazz);
        metaModel.setDescription(ann.description());
        return metaModel;
    }

    public static ActivityMetaModel getActivityMetaModelFromAnnotation(Class<?> clazz) {
        TipiActivity ann = clazz.getAnnotation(TipiActivity.class);
        ActivityMetaModel metaModel = new ActivityMetaModel(clazz);
        metaModel.setDescription(ann.description());
        return metaModel;
    }

    private static List<VariableDescription> getVariableDescriptions(TipiTopProcess topProcAnn) {
        if (topProcAnn.variables() != null && topProcAnn.variables().length > 0) {
            ArrayList<VariableDescription> varsDesc = new ArrayList<VariableDescription>();
            for (TipiVariable var : topProcAnn.variables()) {
                varsDesc.add(new VariableDescription(var.name(), var.type(), var.description(), var.testingOnly(), StringUtils.trimToNull((String)var.defaultValue())));
            }
            return varsDesc;
        }
        return null;
    }
}

