/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.command.impl;

import ch.sharedvd.tipi.engine.command.Command;
import ch.sharedvd.tipi.engine.command.MetaModelHelper;
import ch.sharedvd.tipi.engine.meta.ActivityMetaModel;
import ch.sharedvd.tipi.engine.meta.TopProcessMetaModel;
import ch.sharedvd.tipi.engine.model.DbActivity;
import ch.sharedvd.tipi.engine.runner.TopProcessGroupLauncher;
import ch.sharedvd.tipi.engine.utils.Assert;

public abstract class ActivityCommand
extends Command {
    private long activityId;
    private DbActivity model;

    public ActivityCommand(long id) {
        this.activityId = id;
    }

    long getActivityId() {
        return this.activityId;
    }

    protected TopProcessMetaModel getTopProcess() {
        Assert.notNull((Object)this.getModel(), (String)("ActivityID: " + this.activityId));
        Assert.notNull((Object)this.getModel().getProcessOrThis(), (String)("ActivityID: " + this.activityId));
        Assert.notNull((Object)this.getModel().getProcessOrThis().getFqn(), (String)("ActivityID: " + this.activityId));
        Assert.isFalse(this.getModel().getProcessOrThis().getFqn().isEmpty(), "ActivityID: " + this.activityId);
        TopProcessMetaModel p = MetaModelHelper.getTopProcessMeta(this.getModel().getProcessOrThis().getFqn());
        Assert.notNull((Object)p);
        return p;
    }

    protected ActivityMetaModel getMeta() {
        Assert.notNull((Object)this.getModel(), (String)("ActivityID: " + this.activityId));
        Assert.notNull((Object)this.getModel().getFqn(), (String)("ActivityID: " + this.activityId));
        Assert.isFalse(this.getModel().getFqn().isEmpty(), "ActivityID: " + this.activityId);
        ActivityMetaModel mm = MetaModelHelper.getMeta(this.getModel().getFqn());
        Assert.notNull((Object)mm);
        return mm;
    }

    protected TopProcessMetaModel getTopProcMeta() {
        ActivityMetaModel mm = MetaModelHelper.getMeta(this.getModel().getFqn());
        TopProcessMetaModel sub = null;
        if (mm instanceof TopProcessMetaModel) {
            sub = (TopProcessMetaModel)mm;
        }
        return sub;
    }

    protected DbActivity getModel() {
        if (this.model == null) {
            this.model = (DbActivity)this.activityRepository.findOne(Long.valueOf(this.getActivityId()));
        }
        return this.model;
    }

    protected TopProcessGroupLauncher getLauncher() {
        return this.getLauncher(this.getTopProcess());
    }

    protected void runActivity() {
        this.runActivity(this.getModel(), this.getMeta(), this.getTopProcess());
    }

    @Override
    public String toString() {
        StringBuilder msg = new StringBuilder();
        msg.append(super.toString()).append(" ActivityId: ").append(this.getActivityId());
        if (null != this.model) {
            msg.append(" ").append(this.model.getFqn());
        }
        return msg.toString();
    }
}

