/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.command.impl;

import ch.sharedvd.tipi.engine.command.Command;
import ch.sharedvd.tipi.engine.command.MetaModelHelper;
import ch.sharedvd.tipi.engine.meta.ActivityMetaModel;
import ch.sharedvd.tipi.engine.meta.TopProcessMetaModel;
import ch.sharedvd.tipi.engine.model.DbActivity;
import ch.sharedvd.tipi.engine.runner.TopProcessGroupLauncher;
import ch.sharedvd.tipi.engine.runner.TopProcessGroupManager;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class RunExecutingActivitiesCommand
extends Command {
    private static final Logger LOGGER = LoggerFactory.getLogger(RunExecutingActivitiesCommand.class);

    @Override
    public void execute() {
        long begin = System.currentTimeMillis();
        this.removeOtherSameCommands();
        int nbActivitiesStarted = 0;
        int nbGroups = 0;
        List<String> tpNames = this.activityService.getTopProcessNamesWithExecutingActivities();
        this.sortTopProcessesByPriority(tpNames);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Groupes tri\u00e9s: " + tpNames);
        }
        for (String grpName : tpNames) {
            TopProcessMetaModel tp = MetaModelHelper.getTopProcessMeta(grpName);
            Assert.notNull((Object)tp, (String)("Le process " + grpName + " n'a pas \u00e9t\u00e9 trouv\u00e9"));
            TopProcessGroupManager.RunReason reason = this.groupManager.hasRoom(tp);
            if (reason != TopProcessGroupManager.RunReason.OK) continue;
            nbActivitiesStarted += this.launchForTopProcess(tp);
            ++nbGroups;
        }
        long diff = System.currentTimeMillis() - begin;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Places dans " + nbGroups + " / groupes. Started: " + nbActivitiesStarted + String.format(" (Duree: %.3f [secs])", (double)diff / 1000.0));
        }
    }

    private void sortTopProcessesByPriority(List<String> names) {
        Collections.sort(names, new Comparator<String>(){

            @Override
            public int compare(String name1, String name2) {
                TopProcessGroupLauncher tp1 = RunExecutingActivitiesCommand.this.groupManager.getLauncher(name1);
                TopProcessGroupLauncher tp2 = RunExecutingActivitiesCommand.this.groupManager.getLauncher(name2);
                if (tp1 == null) {
                    return -1;
                }
                if (tp2 == null) {
                    return 1;
                }
                if (tp1.getPriority() == tp2.getPriority()) {
                    return tp1.getTopProcessMetaModel().getFQN().compareTo(tp2.getTopProcessMetaModel().getFQN());
                }
                return tp1.getPriority() - tp2.getPriority();
            }
        });
    }

    private int launchForTopProcess(TopProcessMetaModel topProcess) {
        TopProcessGroupLauncher launcher = this.groupManager.getLauncher(topProcess.getFQN());
        Assert.notNull((Object)launcher);
        List<DbActivity> nexts = launcher.getNextReadyActivities();
        if (LOGGER.isDebugEnabled()) {
            StringBuilder str = new StringBuilder("Ready activities returned: [");
            for (DbActivity a : nexts) {
                str.append("{").append(a.getId()).append(",").append(a.getFqn()).append("},");
            }
            str.append("]");
            LOGGER.debug(str.toString());
        }
        int nbStarted = 0;
        if (nexts.size() > 0) {
            for (DbActivity act : nexts) {
                ActivityMetaModel meta = MetaModelHelper.getMeta(act.getFqn());
                if (meta != null) {
                    if (!this.runActivity(act, meta, topProcess)) continue;
                    ++nbStarted;
                    continue;
                }
                LOGGER.error("Impossible de trouver le meta pour l'activit\u00e9 : " + act.getFqn());
            }
        }
        return nbStarted;
    }

    private void removeOtherSameCommands() {
        this.commandService.removeCommandOfClass(this.getClass());
    }
}

