/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.infos;

import ch.sharedvd.tipi.engine.model.ActivityState;
import ch.sharedvd.tipi.engine.model.DbActivity;
import ch.sharedvd.tipi.engine.model.DbSubProcess;
import ch.sharedvd.tipi.engine.model.DbTopProcess;
import ch.sharedvd.tipi.engine.utils.QuantityFormatter;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;

public class TipiActivityInfos
implements Serializable {
    private static final long serialVersionUID = 1L;
    public long id;
    public String type;
    public String nameOrProcessName;
    public long processId;
    public String processName;
    public long parentId;
    public String parentName;
    public String description;
    public boolean requestEndExecution;
    public Date dateCreation;
    public Date dateStartExecute;
    public Date dateEndExecute;
    public Date dateEndActivity;
    public ActivityState state;
    public boolean terminated;
    public String correlationId;
    public Map<String, Object> variables;
    public String callstack;

    public TipiActivityInfos(DbActivity model, boolean loadVariables) {
        this.id = model.getId();
        this.type = model instanceof DbTopProcess ? "Process" : (model instanceof DbSubProcess ? "Sous-process" : (model instanceof DbActivity ? "Activit\u00e9" : "Inconnu"));
        this.nameOrProcessName = model.getSimpleName();
        this.processId = model.getProcessOrThis().getId();
        this.processName = model.getProcessOrThis().getSimpleName();
        if (null != model.getParent()) {
            this.parentId = model.getParent().getId();
            this.parentName = model.getParent().getFqn();
        }
        this.requestEndExecution = model.isRequestEndExecution();
        this.dateCreation = model.getCreationDate();
        this.dateStartExecute = model.getDateStartExecute();
        this.dateEndExecute = model.getDateEndExecute();
        this.dateEndActivity = model.getDateEndActivity();
        this.state = model.getState();
        this.terminated = model.isTerminated();
        this.correlationId = model.getCorrelationId();
        this.callstack = model.getCallstack();
        if (loadVariables) {
            this.variables = model.getAllVariables();
        }
    }

    public long getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getNameOrProcessName() {
        return this.nameOrProcessName;
    }

    public String getCallstack() {
        return this.callstack;
    }

    public long getProcessId() {
        return this.processId;
    }

    public String getProcessName() {
        return this.processName;
    }

    public long getParentId() {
        return this.parentId;
    }

    public String getParentName() {
        return this.parentName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRequestEndExecution() {
        return this.requestEndExecution;
    }

    public Date getDateCreation() {
        return this.dateCreation;
    }

    public Date getDateStartExecute() {
        return this.dateStartExecute;
    }

    public Date getDateEndExecute() {
        return this.dateEndExecute;
    }

    public Date getDateEndActivity() {
        return this.dateEndActivity;
    }

    public ActivityState getState() {
        return this.state;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public String getExecutionTime() {
        if (this.dateStartExecute != null) {
            Date dateTo = this.dateEndActivity == null ? new Date() : this.dateEndActivity;
            long diffInMillis = dateTo.getTime() - this.dateStartExecute.getTime();
            String timeFormat = QuantityFormatter.formatMillis(diffInMillis);
            return timeFormat;
        }
        return "0s";
    }

    public String getSimpleProcessName() {
        return this.getProcessName();
    }

    public String toString() {
        return "id=" + this.id + " name=" + this.nameOrProcessName + " state=" + (Object)((Object)this.state);
    }
}

