/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.infos;

import ch.sharedvd.tipi.engine.action.UnknownProcess;
import ch.sharedvd.tipi.engine.command.MetaModelHelper;
import ch.sharedvd.tipi.engine.infos.TipiSubProcessInfos;
import ch.sharedvd.tipi.engine.meta.TopProcessMetaModel;
import ch.sharedvd.tipi.engine.model.ActivityState;
import ch.sharedvd.tipi.engine.model.DbSubProcess;
import ch.sharedvd.tipi.engine.utils.Assert;

public class TipiTopProcessInfos
extends TipiSubProcessInfos {
    private static final long serialVersionUID = 1L;
    private int priority = 0;
    private int nbThreads = 0;
    private long nbActivitesTotal = 0L;
    private long nbActivitesInitial = 0L;
    private long nbActivitesExecuting = 0L;
    private long nbActivitesRetry = 0L;
    private long nbActivitesRequestEndExecution = 0L;
    private long nbActivitesFinished = 0L;
    private long nbActivitesAborted = 0L;
    private long nbActivitesError = 0L;
    private long nbActivitesSuspended = 0L;
    private long nbActivitesWaiting = 0L;

    public TipiTopProcessInfos(DbSubProcess model, boolean loadVariables) {
        super(model, loadVariables);
        TopProcessMetaModel meta = MetaModelHelper.getTopProcessMeta(model.getFqn());
        if (null != meta) {
            this.priority = meta.getPriority();
            this.nbThreads = meta.getNbMaxConcurrent();
            if (meta.getClazz().equals(UnknownProcess.class)) {
                this.nameOrProcessName = "Unknown: " + this.nameOrProcessName;
                this.processName = "Unknown: " + this.processName;
            }
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public int getNbThreads() {
        return this.nbThreads;
    }

    public long getNbActivitesInitial() {
        return this.nbActivitesInitial;
    }

    public void incNbActivitesInitial(Long nbActivitesInitial) {
        this.nbActivitesInitial += nbActivitesInitial.longValue();
    }

    public long getNbActivitesExecuting() {
        return this.nbActivitesExecuting;
    }

    public void incNbActivitesExecuting(Long nbActivitesExecuting) {
        this.nbActivitesExecuting += nbActivitesExecuting.longValue();
    }

    public long getNbActivitesRetry() {
        return this.nbActivitesRetry;
    }

    public void incNbActivitesRetry(Long nbActivites) {
        this.nbActivitesRetry += nbActivites.longValue();
    }

    public long getNbActivitesRequestEndExecution() {
        return this.nbActivitesRequestEndExecution;
    }

    public void incNbActivitesRequestEndExecution(Long nbActivitesRequestEndExecution) {
        this.nbActivitesRequestEndExecution += nbActivitesRequestEndExecution.longValue();
    }

    public long getNbActivitesFinished() {
        return this.nbActivitesFinished;
    }

    public void incNbActivitesFinished(Long nbActivitesFinished) {
        this.nbActivitesFinished += nbActivitesFinished.longValue();
    }

    public long getNbActivitesAborted() {
        return this.nbActivitesAborted;
    }

    public void incNbActivitesAborted(Long nbActivitesAborted) {
        this.nbActivitesAborted += nbActivitesAborted.longValue();
    }

    public long getNbActivitesError() {
        return this.nbActivitesError;
    }

    public void incNbActivitesError(Long nbActivitesError) {
        this.nbActivitesError += nbActivitesError.longValue();
    }

    public long getNbActivitesSuspended() {
        return this.nbActivitesSuspended;
    }

    public void incNbActivitesSuspended(Long nbActivitesSuspended) {
        this.nbActivitesSuspended += nbActivitesSuspended.longValue();
    }

    public long getNbActivitesWaiting() {
        return this.nbActivitesWaiting;
    }

    public void incNbActivitesWaiting(Long nbActivitesWaiting) {
        this.nbActivitesWaiting += nbActivitesWaiting.longValue();
    }

    public long getNbActivitesTotal() {
        return this.nbActivitesTotal;
    }

    public void incNbActivitesTotal(Long nbActivitesTotal) {
        this.nbActivitesTotal += nbActivitesTotal.longValue();
    }

    public void incActivitiesFromState(ActivityState aState, boolean aIsRequestEndExecution, int nbRetry) {
        ++this.nbActivitesTotal;
        if (nbRetry > 0) {
            ++this.nbActivitesRetry;
        }
        if (aIsRequestEndExecution) {
            ++this.nbActivitesRequestEndExecution;
        }
        switch (aState) {
            case INITIAL: {
                ++this.nbActivitesInitial;
                break;
            }
            case EXECUTING: {
                ++this.nbActivitesExecuting;
                break;
            }
            case ABORTED: {
                ++this.nbActivitesAborted;
                break;
            }
            case FINISHED: {
                ++this.nbActivitesFinished;
                break;
            }
            case ERROR: {
                ++this.nbActivitesError;
                break;
            }
            case WAIT_ON_CHILDREN: {
                ++this.nbActivitesWaiting;
                break;
            }
            case SUSPENDED: {
                ++this.nbActivitesSuspended;
                break;
            }
            default: {
                Assert.fail("Not impl");
            }
        }
    }
}

