/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.query;

import ch.sharedvd.tipi.engine.infos.ActivityThreadInfos;
import ch.sharedvd.tipi.engine.infos.ConnectionCapInfos;
import ch.sharedvd.tipi.engine.infos.TipiActivityInfos;
import ch.sharedvd.tipi.engine.infos.TipiSubProcessInfos;
import ch.sharedvd.tipi.engine.infos.TipiTopProcessInfos;
import ch.sharedvd.tipi.engine.model.DbActivity;
import ch.sharedvd.tipi.engine.model.DbSubProcess;
import ch.sharedvd.tipi.engine.model.DbTopProcess;
import ch.sharedvd.tipi.engine.query.TipiCriteria;
import ch.sharedvd.tipi.engine.repository.ActivityRepository;
import ch.sharedvd.tipi.engine.runner.ConnectionCap;
import ch.sharedvd.tipi.engine.runner.ConnectionCapManager;
import ch.sharedvd.tipi.engine.runner.TopProcessGroupManager;
import ch.sharedvd.tipi.engine.utils.Assert;
import ch.sharedvd.tipi.engine.utils.ResultListWithCount;
import ch.sharedvd.tipi.engine.utils.TixTemplate;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class ActivityQueryService {
    @Autowired
    private TixTemplate txTemplate;
    @Autowired
    private ActivityRepository activityRepository;
    @Autowired
    private ConnectionCapManager connectionCapManager;
    @Autowired
    private TopProcessGroupManager topProcessGroupManager;

    public List<Long> getActivitiesForCorrelationId(String aCorrelationId) {
        Assert.fail("");
        return null;
    }

    public TipiActivityInfos getActivityInfos(long id, boolean loadVariables) {
        TipiActivityInfos infos = this.txTemplate.txWith(s -> {
            DbActivity am = (DbActivity)this.activityRepository.findOne(Long.valueOf(id));
            return this.buildActivityOrProcessInfos(am, loadVariables, true);
        });
        return infos;
    }

    public ResultListWithCount<TipiActivityInfos> searchActivities(TipiCriteria criteria, int maxHits) {
        Assert.fail("");
        return null;
    }

    private TipiActivityInfos buildActivityOrProcessInfos(DbActivity am, boolean loadVariables, boolean gatherChildActivities) {
        if (null == am) {
            return null;
        }
        if (am instanceof DbSubProcess) {
            return this.getRunningProcessInfos((DbSubProcess)am, loadVariables, gatherChildActivities);
        }
        return new TipiActivityInfos(am, loadVariables);
    }

    private TipiSubProcessInfos getRunningProcessInfos(DbSubProcess process, boolean loadVariables, boolean gatherChildActivities) {
        TipiSubProcessInfos infos;
        if (process instanceof DbTopProcess) {
            infos = new TipiTopProcessInfos(process, loadVariables);
            ((TipiTopProcessInfos)infos).incActivitiesFromState(process.getState(), process.isRequestEndExecution(), process.getNbRetryDone());
        } else {
            infos = new TipiSubProcessInfos(process, loadVariables);
        }
        if (gatherChildActivities) {
            // empty if block
        }
        return infos;
    }

    public List<ActivityThreadInfos> getThreadsInfos() {
        return this.topProcessGroupManager.getThreadsInfos();
    }

    public List<ConnectionCapInfos> getAllConnectionCupInfos() {
        ArrayList<ConnectionCapInfos> connCupInfos = new ArrayList<ConnectionCapInfos>();
        for (ConnectionCap ct : this.connectionCapManager.getCaps()) {
            connCupInfos.add(new ConnectionCapInfos(ct, this.connectionCapManager));
        }
        return connCupInfos;
    }
}

