/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.runner;

import ch.sharedvd.tipi.engine.action.Activity;
import ch.sharedvd.tipi.engine.action.ActivityResultContext;
import ch.sharedvd.tipi.engine.action.ErrorActivityResultContext;
import ch.sharedvd.tipi.engine.action.SubProcess;
import ch.sharedvd.tipi.engine.client.AbortException;
import ch.sharedvd.tipi.engine.command.CommandHelperService;
import ch.sharedvd.tipi.engine.command.CommandService;
import ch.sharedvd.tipi.engine.command.impl.EndActivityCommand;
import ch.sharedvd.tipi.engine.command.impl.RunExecutingActivitiesCommand;
import ch.sharedvd.tipi.engine.meta.ActivityMetaModel;
import ch.sharedvd.tipi.engine.meta.TopProcessMetaModel;
import ch.sharedvd.tipi.engine.model.ActivityState;
import ch.sharedvd.tipi.engine.model.DbActivity;
import ch.sharedvd.tipi.engine.model.DbSubProcess;
import ch.sharedvd.tipi.engine.repository.ActivityRepository;
import ch.sharedvd.tipi.engine.retry.DefaultRetryPolicy;
import ch.sharedvd.tipi.engine.retry.RetryContext;
import ch.sharedvd.tipi.engine.retry.RetryPolicy;
import ch.sharedvd.tipi.engine.runner.ActivityRunnerContext;
import ch.sharedvd.tipi.engine.runner.ActivityStateChangeService;
import ch.sharedvd.tipi.engine.runner.TopProcessGroupLauncher;
import ch.sharedvd.tipi.engine.utils.Assert;
import ch.sharedvd.tipi.engine.utils.TixTemplate;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContextHolder;

public class ActivityRunner
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActivityRunner.class);
    private final ActivityRepository activityRepository;
    private final CommandHelperService commandHelperService;
    private final CommandService commandService;
    private final TopProcessGroupLauncher topProcessGroupLauncher;
    private final long activityId;
    private final ActivityMetaModel meta;
    private TixTemplate tt;

    public ActivityRunner(ActivityRunnerContext context, long actiId, ActivityMetaModel meta) {
        this.activityId = actiId;
        Assert.isTrue((this.activityId > 0L ? 1 : 0) != 0);
        this.meta = meta;
        Assert.notNull((Object)meta);
        Assert.notNull((Object)context.commandService);
        Assert.notNull((Object)context.activityRepository);
        Assert.notNull((Object)context.commandHelperService);
        Assert.notNull((Object)context.launcher);
        Assert.notNull((Object)context.txManager);
        this.commandService = context.commandService;
        this.activityRepository = context.activityRepository;
        this.commandHelperService = context.commandHelperService;
        this.topProcessGroupLauncher = context.launcher;
        this.tt = new TixTemplate(context.txManager);
    }

    public long getActivityId() {
        return this.activityId;
    }

    public String getActivityName() {
        return this.meta.getFQN();
    }

    public boolean isTopActivity() {
        return this.meta instanceof TopProcessMetaModel;
    }

    @Override
    public void run() {
        try {
            this.topProcessGroupLauncher.initInfosForThread(this);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("ActivityRunner begin. Id: " + this.activityId);
            }
            this.executeAndRetry();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("ActivityRunner ended. Id: " + this.activityId);
            }
        }
        catch (Throwable e) {
            LOGGER.error("Activity " + this.activityId + " ended poorly: " + e, e);
            this.topProcessGroupLauncher.removeRunning(this.activityId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAndRetry() {
        long begin = System.currentTimeMillis();
        try {
            this.executeActivity();
        }
        catch (Throwable t) {
            boolean runExecuting;
            long diff = System.currentTimeMillis() - begin;
            boolean aborted = this.isAborted(t);
            boolean interrupted = this.isInterrupted(t);
            int nbRetry = 0;
            if (!aborted && !interrupted && this.topProcessGroupLauncher.isStarted()) {
                nbRetry = this.incrementNbRetries();
                String baseMessage = "Activity id=" + this.activityId + " retry=" + nbRetry + " (" + this.getActivityName() + ") : rollback done. Retrying? Msg='" + t.getMessage() + "'";
                String msgWithCallstack = "\n" + ExceptionUtils.getStackTrace((Throwable)t);
                RetryContext retryContext = new RetryContext(nbRetry, t, diff);
                boolean canRetry = this.getRetryPolicy().canRetry(retryContext);
                if (!canRetry) {
                    LOGGER.error(msgWithCallstack);
                    this.treatErrorCase(t, nbRetry);
                    runExecuting = false;
                } else {
                    LOGGER.error(baseMessage);
                    LOGGER.debug(msgWithCallstack);
                    runExecuting = true;
                }
            } else {
                runExecuting = false;
            }
            if (interrupted) {
                this.topProcessGroupLauncher.setStatusForThread("Interrupted");
            } else if (aborted) {
                this.topProcessGroupLauncher.setStatusForThread("Aborted");
            } else {
                this.topProcessGroupLauncher.setStatusForThread("Exception:" + nbRetry);
            }
            this.topProcessGroupLauncher.removeRunning(this.activityId);
            if (runExecuting) {
                this.commandService.sendCommand(new RunExecutingActivitiesCommand());
            }
        }
        finally {
            SecurityContextHolder.clearContext();
        }
    }

    private boolean isAborted(Throwable t) {
        AbortException ae = null;
        while (null == ae && null != t) {
            if (t instanceof AbortException) {
                ae = (AbortException)t;
            }
            t = t.getCause();
        }
        return null != ae && ae.getAbortType() == AbortException.AbortType.ABORTED;
    }

    private boolean isInterrupted(Throwable t) {
        boolean interrupted = Thread.currentThread().isInterrupted();
        while (!interrupted && null != t) {
            if (t instanceof InterruptedException) {
                interrupted = true;
            } else if (t instanceof AbortException) {
                interrupted = ((AbortException)t).getAbortType() == AbortException.AbortType.INTERRUPTED;
            }
            t = t.getCause();
        }
        return interrupted;
    }

    private void treatErrorCase(Throwable err, int nbRetry) {
        this.tt.txWithout(status -> {
            String msg = "Activity " + this.activityId + " (" + this.getActivityName() + ") : rollback done. Retrying? Msg='" + err.getMessage() + "'";
            LOGGER.error(msg + "\n" + ExceptionUtils.getStackTrace((Throwable)err));
            try {
                this.onError(err);
            }
            catch (Exception ignored) {
                LOGGER.error(ignored.getMessage(), (Throwable)ignored);
            }
            DbActivity model = (DbActivity)this.activityRepository.findOne(Long.valueOf(this.activityId));
            if (model != null) {
                Assert.isEqual((Object)ActivityState.EXECUTING, (Object)model.getState(), "L'etat du process Id: " + model.getId() + " est impossible: " + (Object)((Object)model.getState()));
                model.setNbRetryDone(nbRetry);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                PrintWriter pw = new PrintWriter(bos);
                for (Throwable th = err; th != null; th = th.getCause()) {
                    th.printStackTrace(pw);
                }
                pw.flush();
                pw.close();
                model.setCallstack(bos.toString());
                ErrorActivityResultContext resultContext = new ErrorActivityResultContext("Type: " + err.getClass().getName() + ". Message: " + err.getMessage());
                ActivityStateChangeService.runnerFinished(model, resultContext);
                this.commandService.sendCommand(new EndActivityCommand(this.activityId));
            } else {
                LOGGER.error("L'activit\u00e9 " + this.activityId + " n'existe plus en DB");
            }
        });
    }

    private void onError(Throwable exception) {
        Activity activityService = this.commandHelperService.createActivity(this.activityId);
        Assert.notNull((Object)activityService);
        activityService.onError(exception);
    }

    private int incrementNbRetries() {
        try {
            return this.tt.txWith(status -> {
                DbActivity activity = (DbActivity)this.activityRepository.findOne(Long.valueOf(this.activityId));
                if (activity != null) {
                    activity.setNbRetryDone(activity.getNbRetryDone() + 1);
                    return activity.getNbRetryDone();
                }
                return 0;
            });
        }
        catch (Throwable er) {
            LOGGER.error("Erreur lors de la tentative d'incr\u00e9mentation du nb de retry pour l'activit\u00e9 " + this.activityId, er);
            return -1;
        }
    }

    private void executeActivity() {
        long begin = System.currentTimeMillis();
        AtomicLong timeBeforeCommit = new AtomicLong();
        Activity finishedActivity = this.tt.txWith(status -> {
            Activity activity;
            DbActivity model = (DbActivity)this.activityRepository.findOne(Long.valueOf(this.activityId));
            Assert.notNull((Object)model, (String)("Impossible de r\u00e9cup\u00e9rer le model pour l'activit\u00e9 " + this.activityId));
            if (!(ActivityState.ABORTED.equals((Object)model.getState()) || model.getProcess() != null && ActivityState.ABORTED.equals((Object)model.getProcess().getState()))) {
                ActivityResultContext resultContext;
                Assert.isEqual((Object)ActivityState.EXECUTING, (Object)model.getState(), "L'etat de l'activity Id: " + model.getId() + " est impossible: " + (Object)((Object)model.getState()));
                activity = this.commandHelperService.createActivity(this.activityId);
                if (null == activity) {
                    StringBuffer msg = new StringBuffer();
                    msg.append("No ActivityServiceFound in registered activities map: Activity info: Nom: ").append(model.getFqn()).append(". Id: ").append(model.getId());
                    LOGGER.error(msg.toString());
                    throw new RuntimeException(msg.toString());
                }
                if (model instanceof DbSubProcess && ((DbSubProcess)model).isExecuted()) {
                    DbSubProcess subProcModel = (DbSubProcess)model;
                    SubProcess sub = (SubProcess)activity;
                    Date dateStart = new Date();
                    try {
                        this.activityRepository.flush();
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Calling terminate()");
                        }
                        resultContext = sub.doTerminate();
                    }
                    finally {
                        subProcModel.setDateStartTerminate(dateStart);
                        subProcModel.setDateEndTerminate(new Date());
                    }
                }
                Date dateStart = new Date();
                try {
                    this.activityRepository.flush();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Calling execute()");
                    }
                    resultContext = activity.doExecute();
                }
                finally {
                    model.setDateStartExecute(dateStart);
                    model.setDateEndExecute(new Date());
                }
                Assert.notNull((Object)resultContext, (String)"Le retour de l'activit\u00e9 ne peut pas etre null");
                if (Thread.currentThread().isInterrupted()) {
                    throw new AbortException(AbortException.AbortType.INTERRUPTED);
                }
                model = (DbActivity)this.activityRepository.findOne(Long.valueOf(this.activityId));
                ActivityStateChangeService.runnerFinished(model, resultContext);
                this.topProcessGroupLauncher.setStatusForThread("Commit");
            } else {
                LOGGER.info("Activit\u00e9 ou process (" + this.getActivityId() + ") ABORTED -> pas de run");
                ActivityStateChangeService.aborted(model);
                this.topProcessGroupLauncher.setStatusForThread("Aborted");
                activity = null;
            }
            this.commandService.sendCommand(new EndActivityCommand(this.activityId));
            timeBeforeCommit.set(System.currentTimeMillis());
            return activity;
        });
        try {
            if (finishedActivity != null) {
                finishedActivity.setFacade(null);
                finishedActivity.onAfterCommit();
            }
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage());
        }
        long end = System.currentTimeMillis();
        long diffCommit = end - timeBeforeCommit.get();
        long diffTotal = end - begin;
        String message = String.format("ActivityRunner(id=%d/%s) termin\u00e9: total=%.3f[s] dont commit=%.3f[s]", this.getActivityId(), this.getActivityName(), (double)diffTotal / 1000.0, (double)diffCommit / 1000.0);
        if (diffCommit > 10000L) {
            LOGGER.warn(message);
        } else if (diffTotal > 60000L) {
            LOGGER.warn(message);
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(message);
        }
    }

    public RetryPolicy getRetryPolicy() {
        return new DefaultRetryPolicy();
    }
}

