/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.runner;

import ch.sharedvd.tipi.engine.runner.stats.TipiThreadStats;
import ch.sharedvd.tipi.engine.runner.stats.TipiThreadsStats;
import java.util.Date;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TipiThreadPoolExecutor
extends ThreadPoolExecutor {
    private TipiThreadsStats stats = new TipiThreadsStats();

    public TipiThreadPoolExecutor() {
        super(0, Integer.MAX_VALUE, 1L, TimeUnit.HOURS, new SynchronousQueue<Runnable>());
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        TipiThreadStats s = this.stats.get(t);
        s.setRunning(true);
        s.setStatus("Running");
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        TipiThreadStats s = this.stats.get(Thread.currentThread());
        s.setRunning(false);
        if (t != null) {
            s.setStatus("Not trap");
        } else {
            s.setStatus("Finished");
        }
    }

    public void purgeStats() {
        this.stats.purge();
    }

    public TipiThreadsStats getPoolStats() {
        return this.stats;
    }

    public void setStatusForThread(String status) {
        TipiThreadStats s = this.stats.get(Thread.currentThread());
        s.setStatus(status);
    }

    public void initInfosForThread(long id, String name) {
        TipiThreadStats s = this.stats.get(Thread.currentThread());
        s.setActivityId(id);
        s.setActivityName(name);
        s.setStartTime(new Date());
    }
}

