/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.runner;

import ch.sharedvd.tipi.engine.command.MetaModelHelper;
import ch.sharedvd.tipi.engine.infos.ActivityThreadInfos;
import ch.sharedvd.tipi.engine.meta.TopProcessMetaModel;
import ch.sharedvd.tipi.engine.runner.ActivityRunningService;
import ch.sharedvd.tipi.engine.runner.ConnectionCapManager;
import ch.sharedvd.tipi.engine.runner.Startable;
import ch.sharedvd.tipi.engine.runner.TopProcessGroupLauncher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class TopProcessGroupManager
implements Startable {
    @Autowired
    protected ActivityRunningService activityService;
    @Autowired
    protected ConnectionCapManager connectionCapManager;
    private final Map<String, TopProcessGroupLauncher> launchers = new HashMap<String, TopProcessGroupLauncher>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        Map<String, TopProcessGroupLauncher> map = this.launchers;
        synchronized (map) {
            this.launchers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws Exception {
        Map<String, TopProcessGroupLauncher> map = this.launchers;
        synchronized (map) {
            for (TopProcessGroupLauncher l : this.launchers.values()) {
                l.shutdown();
            }
        }
    }

    @Override
    public void destroy() throws Exception {
        this.stop();
    }

    private Map<String, TopProcessGroupLauncher> getLaunchers() {
        return Collections.unmodifiableMap(this.launchers);
    }

    public void clearCaches() {
        for (TopProcessGroupLauncher launcher : this.getLaunchers().values()) {
            launcher.clearCache();
        }
    }

    public int getExecutingThreadsCount() {
        int count = 0;
        for (TopProcessGroupLauncher l : this.getLaunchers().values()) {
            count += l.getRunningCount();
        }
        return count;
    }

    public void startAllGroups() throws Exception {
        for (TopProcessGroupLauncher launcher : this.getLaunchers().values()) {
            Assert.notNull((Object)launcher);
            launcher.start();
        }
    }

    public void stopAllGroups() throws Exception {
        for (TopProcessGroupLauncher launcher : this.getLaunchers().values()) {
            Assert.notNull((Object)launcher);
            launcher.stop();
        }
    }

    public void restart(TopProcessMetaModel topProcess, int nbMax, int priority) throws Exception {
        TopProcessGroupLauncher launcher = this.getLauncher(topProcess);
        Assert.notNull((Object)launcher);
        launcher.setNbMaxConcurrentActivities(nbMax);
        launcher.setPriority(priority);
        launcher.start();
    }

    public void start(TopProcessMetaModel topProcess) throws Exception {
        TopProcessGroupLauncher launcher = this.getLauncher(topProcess);
        Assert.notNull((Object)launcher);
        launcher.start();
    }

    public void stop(TopProcessMetaModel topProcess) throws Exception {
        TopProcessGroupLauncher launcher = this.getLauncher(topProcess);
        Assert.notNull((Object)launcher);
        launcher.stop();
    }

    public TopProcessGroupLauncher getLauncher(String fqn) {
        Assert.notNull((Object)fqn);
        TopProcessGroupLauncher launcher = this.getLaunchers().get(fqn);
        if (launcher == null) {
            TopProcessMetaModel meta = MetaModelHelper.getTopProcessMeta(fqn);
            launcher = new TopProcessGroupLauncher(meta, this.activityService, this.connectionCapManager, true);
            this.launchers.put(fqn, launcher);
        }
        Assert.notNull((Object)launcher, (String)("Name: " + fqn));
        return launcher;
    }

    public TopProcessGroupLauncher getLauncher(TopProcessMetaModel topProcess) {
        Assert.notNull((Object)topProcess);
        return this.getLauncher(topProcess.getFQN());
    }

    public List<TopProcessGroupLauncher> getAllGroupLaunchers() {
        ArrayList<TopProcessGroupLauncher> list = new ArrayList<TopProcessGroupLauncher>();
        for (TopProcessGroupLauncher l : this.getLaunchers().values()) {
            list.add(l);
        }
        return list;
    }

    public boolean hasActivityPending() {
        boolean has = false;
        for (TopProcessGroupLauncher l : this.getLaunchers().values()) {
            has = has || l.getRunningCount() > 0;
        }
        return has;
    }

    public RunReason hasRoom(TopProcessMetaModel topProcess) {
        Assert.notNull((Object)topProcess);
        TopProcessGroupLauncher launcher = this.getLauncher(topProcess);
        Assert.notNull((Object)launcher);
        if (!launcher.hasTopRoom()) {
            return RunReason.NO_TOP_ROOM;
        }
        if (!launcher.hasRoom()) {
            return RunReason.NO_ROOM;
        }
        return RunReason.OK;
    }

    public List<ActivityThreadInfos> getThreadsInfos() {
        ArrayList<ActivityThreadInfos> threads = new ArrayList<ActivityThreadInfos>();
        for (TopProcessGroupLauncher l : this.getLaunchers().values()) {
            List<ActivityThreadInfos> ths = l.getThreadsInfos();
            threads.addAll(ths);
        }
        return threads;
    }

    public void setMaxConcurrentActivitiesForGroup(String aGroupName, int nb) {
        this.getLauncher(aGroupName).setNbMaxConcurrentActivities(nb);
    }

    public void setPriorityForGroup(String aGroupName, int aPrio) {
        this.getLauncher(aGroupName).setPriority(aPrio);
    }

    public static enum RunReason {
        OK,
        NO_ROOM,
        EXCLUSIVE,
        NO_TOP_ROOM;

    }
}

