/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.utils;

import ch.sharedvd.tipi.engine.utils.TxCallbackException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

public class TixTemplate {
    private final PlatformTransactionManager transactionManager;

    public TixTemplate(PlatformTransactionManager txMgr) {
        Assert.notNull((Object)txMgr);
        this.transactionManager = txMgr;
    }

    public void assertExistingTransaction() {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(2);
        this.getTransactionManager().getTransaction((TransactionDefinition)def);
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void txWithout(final TxWithout callback) {
        TransactionTemplate tmpl = new TransactionTemplate(this.getTransactionManager());
        tmpl.setPropagationBehavior(0);
        tmpl.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                try {
                    callback.execute(status);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new TxCallbackException(e);
                }
            }
        });
    }

    public <T> T txWith(TxWith<T> callback) {
        TransactionTemplate tmpl = new TransactionTemplate(this.getTransactionManager());
        tmpl.setPropagationBehavior(0);
        return (T)tmpl.execute(status -> {
            try {
                return callback.execute(status);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TxCallbackException(e);
            }
        });
    }

    @FunctionalInterface
    public static interface TxWith<T> {
        public T execute(TransactionStatus var1) throws Exception;
    }

    @FunctionalInterface
    public static interface TxWithout {
        public void execute(TransactionStatus var1) throws Exception;
    }
}

