/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.utils;

import ch.sharedvd.tipi.engine.client.VariableMap;
import ch.sharedvd.tipi.engine.meta.TopProcessMetaModel;
import ch.sharedvd.tipi.engine.meta.VariableDescription;
import ch.sharedvd.tipi.engine.meta.VariableType;
import ch.sharedvd.tipi.engine.utils.ArrayLong;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class VariablesUtil {
    public static final Logger LOGGER = LoggerFactory.getLogger(VariablesUtil.class);

    public static VariableMap buildVariableMapFromString(TopProcessMetaModel model, Map<String, Object> aParams, String separator) {
        VariableMap vars = new VariableMap();
        for (Map.Entry<String, Object> entry : aParams.entrySet()) {
            String key = entry.getKey();
            Object val = entry.getValue();
            if (val instanceof String) {
                Serializable value;
                VariableDescription variableDescription = VariablesUtil.isKnownVariable(model.getVariablesDescription(), key);
                if (variableDescription == null || (value = VariablesUtil.parseValue((String)val, variableDescription.getVariableType(), separator)) == null) continue;
                vars.put(key, value);
                continue;
            }
            if (val instanceof Serializable) {
                vars.put(key, (Serializable)val);
                continue;
            }
            LOGGER.warn("VariableType [" + key + "] non serializable");
        }
        VariablesUtil.addDefaultVariables(model, separator, vars);
        return vars;
    }

    public static VariableMap buildDefaultVariablesMap(TopProcessMetaModel model) {
        VariableMap vars = new VariableMap();
        VariablesUtil.addDefaultVariables(model, ",", vars);
        return vars;
    }

    private static void addDefaultVariables(TopProcessMetaModel model, String separator, VariableMap vars) {
        List<VariableDescription> list = model.getVariablesDescription();
        if (list != null) {
            for (VariableDescription description : list) {
                Serializable value;
                if (vars.get(description.getName()) != null || description.getDefaultValue() == null || (value = VariablesUtil.parseValue(description.getDefaultValue(), description.getVariableType(), separator)) == null) continue;
                vars.put(description.getName(), value);
            }
        }
    }

    private static Serializable parseValue(String valueAsString, VariableType type, String separator) {
        Object value = null;
        switch (type) {
            case ArrayLong: {
                ArrayList<Long> longs = new ArrayList<Long>();
                for (String var : valueAsString.split(separator)) {
                    Long varLong = Long.parseLong(var);
                    longs.add(varLong);
                }
                value = new ArrayLong(longs);
                break;
            }
            case String: {
                value = valueAsString;
                break;
            }
            case LocalDate: {
                try {
                    int i = Integer.parseInt(valueAsString);
                    Assert.isTrue((boolean)false);
                }
                catch (NumberFormatException e) {
                    LOGGER.error("Impossible de parser [" + valueAsString + "] au format RegDate");
                }
                break;
            }
            case Long: {
                try {
                    value = Long.parseLong(valueAsString);
                }
                catch (NumberFormatException e) {
                    LOGGER.error("Impossible de parser [" + valueAsString + "] au format Long");
                }
                break;
            }
            default: {
                LOGGER.warn("VariableType [" + type.toString() + "] non impl\u00e9ment\u00e9");
            }
        }
        return value;
    }

    private static VariableDescription isKnownVariable(List<VariableDescription> availableVariables, String variable) {
        if (availableVariables != null) {
            for (VariableDescription vd : availableVariables) {
                if (!vd.getName().equals(variable)) continue;
                return vd;
            }
        }
        return null;
    }
}

