/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.client;

import ch.sharedvd.tipi.engine.action.TopProcess;
import ch.sharedvd.tipi.engine.client.TipiTopProcess;
import ch.sharedvd.tipi.engine.meta.MetaModelHelper;
import ch.sharedvd.tipi.engine.meta.TopProcessMetaModel;
import ch.sharedvd.tipi.engine.registry.TipiRegistry;
import ch.sharedvd.tipi.engine.utils.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractRegistrar {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRegistrar.class);
    @Autowired
    private TipiRegistry registry;

    protected void registerClass(Class<?> c) throws Exception {
        boolean registered = false;
        try {
            TopProcessMetaModel meta;
            if (c.getAnnotation(TipiTopProcess.class) != null) {
                if (!TopProcess.class.isAssignableFrom(c)) {
                    throw new IllegalArgumentException("La classe " + c.getSimpleName() + " est annot\u00e9e avec @TipiTopProcess mais n'h\u00e9rite pas de TopProcess");
                }
                meta = MetaModelHelper.createTopProcessMetaModel(c);
            } else {
                meta = (TopProcessMetaModel)MetaModelHelper.getMetaFromStaticField(c);
            }
            if (meta != null) {
                this.registry.register(meta);
                registered = true;
            }
        }
        catch (Exception e) {
            LOGGER.error("Impossible d'enregistrer: " + c.getSimpleName(), (Throwable)e);
            throw e;
        }
        Assert.isTrue((boolean)registered, (String)("Impossible d'enregistrer: " + c.getSimpleName()));
    }

    public TipiRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(TipiRegistry registry) {
        this.registry = registry;
    }
}

