/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.meta;

import ch.sharedvd.tipi.engine.action.Activity;
import ch.sharedvd.tipi.engine.action.UnknownProcess;
import ch.sharedvd.tipi.engine.client.TipiActivity;
import ch.sharedvd.tipi.engine.client.TipiSubProcess;
import ch.sharedvd.tipi.engine.client.TipiTopProcess;
import ch.sharedvd.tipi.engine.client.TipiUnknownActivity;
import ch.sharedvd.tipi.engine.client.TipiVariable;
import ch.sharedvd.tipi.engine.meta.ActivityMetaModel;
import ch.sharedvd.tipi.engine.meta.SubProcessMetaModel;
import ch.sharedvd.tipi.engine.meta.TopProcessMetaModel;
import ch.sharedvd.tipi.engine.meta.VariableDescription;
import ch.sharedvd.tipi.engine.utils.Assert;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaModelHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaModelHelper.class);

    public static TopProcessMetaModel getTopProcessMeta(String fqn) {
        ActivityMetaModel amm = MetaModelHelper.createActivityMetaModel(fqn);
        if (amm instanceof TopProcessMetaModel) {
            return (TopProcessMetaModel)amm;
        }
        return null;
    }

    public static ActivityMetaModel createActivityMetaModel(String fqn) {
        try {
            Class<?> activity = Class.forName(fqn);
            return MetaModelHelper.createActivityMetaModel(activity);
        }
        catch (ClassNotFoundException e) {
            Class<UnknownProcess> activity = UnknownProcess.class;
            return MetaModelHelper.createActivityMetaModel(activity);
        }
        catch (RuntimeException ee) {
            throw ee;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ActivityMetaModel createActivityMetaModel(Class<? extends Activity> clazz) {
        if (clazz.getAnnotation(TipiUnknownActivity.class) != null) {
            return MetaModelHelper.createUnkonwnProcessMetaModel(clazz);
        }
        if (clazz.getAnnotation(TipiTopProcess.class) != null) {
            return MetaModelHelper.createTopProcessMetaModel(clazz);
        }
        if (clazz.getAnnotation(TipiSubProcess.class) != null) {
            return MetaModelHelper.createSubProcessMetaModel(clazz);
        }
        if (clazz.getAnnotation(TipiActivity.class) != null) {
            return MetaModelHelper.createActivityMetaModelFromAnnotation(clazz);
        }
        return MetaModelHelper.getMetaFromStaticField(clazz);
    }

    @Deprecated
    public static ActivityMetaModel getMetaFromStaticField(Class<?> c) {
        try {
            Field field = c.getField("META");
            return (ActivityMetaModel)field.get(null);
        }
        catch (NoSuchFieldException ex) {
            try {
                Field field = c.getField("meta");
                return (ActivityMetaModel)field.get(null);
            }
            catch (SecurityException e) {
                LOGGER.error("Property meta for class " + c.getName() + " is not public");
            }
            catch (NoSuchFieldException e) {
                LOGGER.trace("No meta property for class" + c.getName());
            }
            catch (IllegalAccessException e) {
                LOGGER.trace("meta property for class" + c.getName() + " has no public access");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static TopProcessMetaModel createUnkonwnProcessMetaModel(Class<?> clazz) {
        TopProcessMetaModel metaModel = new TopProcessMetaModel(clazz, null, null, 1, 10, 10, "Unknown", true);
        return metaModel;
    }

    public static TopProcessMetaModel createTopProcessMetaModel(Class<?> clazz) {
        TipiTopProcess ann = clazz.getAnnotation(TipiTopProcess.class);
        Assert.notNull((Object)ann, (String)("No annotation found on " + clazz));
        VariableDescription[] varsDesc = MetaModelHelper.getVariableDescriptions(ann);
        TopProcessMetaModel metaModel = new TopProcessMetaModel(clazz, varsDesc, ann);
        metaModel.setDeleteWhenFinished(ann.deleteWhenFinished());
        metaModel.setStartable(ann.startable());
        metaModel.setShownInUI(ann.showInUi());
        return metaModel;
    }

    static SubProcessMetaModel createSubProcessMetaModel(Class<?> clazz) {
        TipiSubProcess ann = clazz.getAnnotation(TipiSubProcess.class);
        Assert.notNull((Object)ann, (String)("No annotation found on " + clazz));
        SubProcessMetaModel metaModel = new SubProcessMetaModel(clazz, ann.description());
        return metaModel;
    }

    static ActivityMetaModel createActivityMetaModelFromAnnotation(Class<?> clazz) {
        TipiActivity ann = clazz.getAnnotation(TipiActivity.class);
        Assert.notNull((Object)ann, (String)("No annotation found on " + clazz));
        ActivityMetaModel metaModel = new ActivityMetaModel(clazz, ann.description());
        return metaModel;
    }

    private static VariableDescription[] getVariableDescriptions(TipiTopProcess topProcAnn) {
        if (topProcAnn.variables() != null && topProcAnn.variables().length > 0) {
            ArrayList<VariableDescription> varsDesc = new ArrayList<VariableDescription>();
            for (TipiVariable var : topProcAnn.variables()) {
                varsDesc.add(new VariableDescription(var.name(), var.type(), var.description(), StringUtils.trimToNull((String)var.defaultValue())));
            }
            return varsDesc.toArray(new VariableDescription[varsDesc.size()]);
        }
        return null;
    }
}

