/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.runner;

import ch.sharedvd.tipi.engine.infos.ActivityThreadInfos;
import ch.sharedvd.tipi.engine.meta.TopProcessMetaModel;
import ch.sharedvd.tipi.engine.model.DbActivity;
import ch.sharedvd.tipi.engine.runner.ActivityRunner;
import ch.sharedvd.tipi.engine.runner.ActivityRunningService;
import ch.sharedvd.tipi.engine.runner.ConnectionCapManager;
import ch.sharedvd.tipi.engine.runner.TipiThreadPoolExecutor;
import ch.sharedvd.tipi.engine.runner.stats.TipiThreadStats;
import ch.sharedvd.tipi.engine.utils.Assert;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class TopProcessGroupLauncher {
    private static final Logger LOGGER = LoggerFactory.getLogger(TopProcessGroupLauncher.class);
    public static int CACHE_SIZE = 1000;
    protected ActivityRunningService activityService;
    protected ConnectionCapManager connectionCapManager;
    private List<DbActivity> readyActivities = new ArrayList<DbActivity>();
    private TopProcessMetaModel topProcess;
    private boolean groupStarted = true;
    private final AtomicBoolean groupShutdown = new AtomicBoolean(false);
    private TipiThreadPoolExecutor executor = new TipiThreadPoolExecutor();
    private final Set<Long> runningTopActivities = new HashSet<Long>();
    private final Set<Long> runningActivities = new HashSet<Long>();
    private final int nbMaxTopConcurrentActivities;
    private int nbMaxConcurrentActivities;
    private int priority;

    public TopProcessGroupLauncher(final TopProcessMetaModel topProcess, ActivityRunningService activityService, ConnectionCapManager connectionsCup, boolean startGroup) {
        Assert.notNull((Object)topProcess);
        Assert.notNull((Object)activityService);
        Assert.notNull((Object)connectionsCup);
        this.topProcess = topProcess;
        this.activityService = activityService;
        this.connectionCapManager = connectionsCup;
        this.groupStarted = startGroup;
        final ThreadGroup threadGroup = new ThreadGroup("TG-" + topProcess.getFQN());
        this.nbMaxTopConcurrentActivities = topProcess.getNbMaxTopConcurrent();
        this.nbMaxConcurrentActivities = topProcess.getNbMaxConcurrent();
        this.priority = topProcess.getPriority();
        Assert.isTrue((this.priority > 0 ? 1 : 0) != 0);
        this.executor.setThreadFactory(new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                StringBuilder name = new StringBuilder("AT-");
                name.append(topProcess.getSimpleName()).append("-").append(String.format("%02d", this.threadNumber.getAndIncrement()));
                Thread t = new Thread(threadGroup, r, name.toString(), 0L);
                t.setDaemon(true);
                t.setPriority(5);
                return t;
            }
        });
    }

    public void clearCache() {
        this.readyActivities = new ArrayList<DbActivity>();
    }

    private int getNbMaxStartableActivities() {
        int nbrMax = this.connectionCapManager.getAvailableConnections(this.topProcess);
        if (this.nbMaxConcurrentActivities < 0) {
            return nbrMax;
        }
        return Math.min(nbrMax, this.nbMaxConcurrentActivities);
    }

    public List<DbActivity> getNextReadyActivities() {
        if (this.readyActivities.size() == 0) {
            this.populateCache();
        }
        int nbActivitiesReady = this.readyActivities.size();
        int nbMax = this.getNbMaxStartableActivities();
        int toIndex = nbMax < 0 || this.readyActivities.size() < nbMax ? this.readyActivities.size() : nbMax;
        List<DbActivity> toRetList = this.readyActivities.subList(0, toIndex);
        this.readyActivities = this.readyActivities.subList(toIndex, this.readyActivities.size());
        Assert.isEqual(nbActivitiesReady, this.readyActivities.size() + toRetList.size(), "Non egal!");
        if (toRetList.size() > 0 && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Returning " + toRetList.size() + " activities for group " + this.topProcess.getFQN() + ". The cache still contains " + this.readyActivities.size() + " activities ready to run");
        }
        if (!this.readyActivities.isEmpty() && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Le cache du groupe " + this.topProcess.getFQN() + " contient encore " + this.readyActivities.size() + " activites ready to run");
        }
        return toRetList;
    }

    private void populateCache() {
        Assert.notNull(this.runningActivities);
        Assert.isEqual(0, this.readyActivities.size());
        int cacheSize = CACHE_SIZE;
        if (cacheSize < this.runningActivities.size()) {
            cacheSize = this.runningActivities.size() + 2;
        }
        List<DbActivity> executingActivities = this.activityService.getExecutingActivities(this.topProcess.getFQN(), this.runningActivities, cacheSize);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Found " + executingActivities.size() + " activities ready to run for group " + this.topProcess.getFQN());
        }
        this.readyActivities = new ArrayList<DbActivity>();
        for (DbActivity act : executingActivities) {
            if (this.runningActivities.contains(act.getId())) continue;
            this.readyActivities.add(act);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (!this.groupShutdown.get()) {
            AtomicBoolean atomicBoolean = this.groupShutdown;
            synchronized (atomicBoolean) {
                this.executor.shutdownNow();
                this.groupShutdown.set(true);
            }
        }
    }

    public void start() {
        this.groupStarted = true;
    }

    public void stop() {
        this.groupStarted = false;
    }

    public final boolean isStarted() {
        return !this.groupShutdown.get() && this.groupStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRunning(long id) {
        Set<Long> set = this.runningActivities;
        synchronized (set) {
            this.connectionCapManager.remove(id);
            this.runningTopActivities.remove(id);
            return this.runningActivities.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRunningCount() {
        Set<Long> set = this.runningActivities;
        synchronized (set) {
            return this.runningActivities.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTopRoom() {
        if (this.groupShutdown.get()) {
            return false;
        }
        if (this.nbMaxTopConcurrentActivities == -1) {
            return true;
        }
        Set<Long> set = this.runningTopActivities;
        synchronized (set) {
            if (this.runningTopActivities.size() < this.nbMaxTopConcurrentActivities) {
                return true;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Pas de place pour d\u00e9marrer un nouveau top-process: " + this.topProcess.getFQN() + ". Il y a d\u00e9j\u00e0 " + this.runningTopActivities.size() + " top-processus.");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRoom() {
        if (!this.groupShutdown.get()) {
            Set<Long> set = this.runningActivities;
            synchronized (set) {
                if (this.nbMaxConcurrentActivities < 0 || this.runningActivities.size() < this.nbMaxConcurrentActivities) {
                    return true;
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Pas de place dans le groupe: " + this.topProcess.getFQN() + ". Il y a deja " + this.runningActivities.size() + " activit\u00e9s.");
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning(long id) {
        Set<Long> set = this.runningActivities;
        synchronized (set) {
            return this.runningActivities.contains(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startNewThread(ActivityRunner runner) {
        boolean wasStarted = false;
        if (this.isStarted()) {
            Set<Long> set = this.runningActivities;
            synchronized (set) {
                Assert.isFalse(this.runningActivities.contains(runner.getActivityId()), "Error");
                this.runningActivities.add(runner.getActivityId());
                this.connectionCapManager.add(runner.getActivityName(), runner.getActivityId());
                try {
                    ThreadStarterSynchronization synchro = new ThreadStarterSynchronization(runner);
                    TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)synchro);
                    wasStarted = true;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (runner.isTopActivity()) {
                set = this.runningTopActivities;
                synchronized (set) {
                    this.runningTopActivities.add(runner.getActivityId());
                }
            }
        }
        return wasStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startNewThreadDeffered(ActivityRunner runner) {
        AtomicBoolean atomicBoolean = this.groupShutdown;
        synchronized (atomicBoolean) {
            if (!this.groupShutdown.get()) {
                this.executor.execute(runner);
            }
        }
    }

    public TopProcessMetaModel getTopProcessMetaModel() {
        return this.topProcess;
    }

    public void setStatusForThread(String status) {
        this.executor.setStatusForThread(status);
    }

    public void initInfosForThread(ActivityRunner activity) {
        this.executor.initInfosForThread(activity.getActivityId(), activity.getActivityName());
    }

    public List<ActivityThreadInfos> getThreadsInfos() {
        ArrayList<ActivityThreadInfos> threads = new ArrayList<ActivityThreadInfos>();
        this.executor.purgeStats();
        for (TipiThreadStats s : this.executor.getPoolStats()) {
            threads.add(new ActivityThreadInfos(s));
        }
        return threads;
    }

    public int getNbMaxConcurrentActivities() {
        return this.nbMaxConcurrentActivities;
    }

    public void setNbMaxConcurrentActivities(int nbMaxConcurrentActivities) {
        this.nbMaxConcurrentActivities = nbMaxConcurrentActivities;
    }

    public void setPriority(int prio) {
        this.priority = prio;
    }

    public int getPriority() {
        return this.priority;
    }

    private class ThreadStarterSynchronization
    implements TransactionSynchronization {
        private final ActivityRunner runner;

        ThreadStarterSynchronization(ActivityRunner runner) {
            this.runner = runner;
        }

        public void suspend() {
        }

        public void resume() {
        }

        public void flush() {
        }

        public void beforeCommit(boolean readOnly) {
        }

        public void beforeCompletion() {
        }

        public void afterCommit() {
        }

        public void afterCompletion(int status) {
            if (0 == status) {
                TopProcessGroupLauncher.this.startNewThreadDeffered(this.runner);
            } else if (1 == status) {
                TopProcessGroupLauncher.this.removeRunning(this.runner.getActivityId());
            } else {
                Assert.fail("Impossible.");
            }
        }
    }
}

