/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.infos;

import ch.sharedvd.tipi.engine.model.ActivityState;
import ch.sharedvd.tipi.engine.model.DbActivity;
import ch.sharedvd.tipi.engine.model.DbSubProcess;
import ch.sharedvd.tipi.engine.model.DbTopProcess;
import ch.sharedvd.tipi.engine.utils.QuantityFormatter;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;

public class TipiActivityInfos
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long id;
    private String fqn;
    private String simpleName;
    private String type;
    private String processFqn;
    private long processId;
    private long parentId;
    private String parentName;
    private String description;
    private boolean requestEndExecution;
    private Date dateCreation;
    private Date dateStartExecute;
    private Date dateEndExecute;
    private Date dateEndActivity;
    private ActivityState state;
    private boolean terminated;
    private String correlationId;
    private Map<String, Object> variables;
    private String callstack;

    public TipiActivityInfos(DbActivity db, String description, boolean loadVariables) {
        this.id = db.getId();
        this.type = db instanceof DbTopProcess ? "Process" : (db instanceof DbSubProcess ? "Sous-process" : (db instanceof DbActivity ? "Activit\u00e9" : "Inconnu"));
        this.fqn = db.getFqn();
        this.simpleName = db.getSimpleName();
        this.description = description;
        this.processId = db.getProcessOrThis().getId();
        this.processFqn = db.getProcessOrThis().getFqn();
        if (null != db.getParent()) {
            this.parentId = db.getParent().getId();
            this.parentName = db.getParent().getFqn();
        }
        this.requestEndExecution = db.isRequestEndExecution();
        this.dateCreation = db.getCreationDate();
        this.dateStartExecute = db.getDateStartExecute();
        this.dateEndExecute = db.getDateEndExecute();
        this.dateEndActivity = db.getDateEndActivity();
        this.state = db.getState();
        this.terminated = db.isTerminated();
        this.correlationId = db.getCorrelationId();
        this.callstack = db.getCallstack();
        if (loadVariables) {
            this.variables = db.getAllVariables();
        }
    }

    public long getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getFqn() {
        return this.fqn;
    }

    public String getProcessFqn() {
        return this.processFqn;
    }

    void setProcessFqn(String processFqn) {
        this.processFqn = processFqn;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    void setSimpleName(String simpleName) {
        this.simpleName = simpleName;
    }

    public String getCallstack() {
        return this.callstack;
    }

    public long getProcessId() {
        return this.processId;
    }

    public long getParentId() {
        return this.parentId;
    }

    public String getParentName() {
        return this.parentName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRequestEndExecution() {
        return this.requestEndExecution;
    }

    public Date getDateCreation() {
        return this.dateCreation;
    }

    public Date getDateStartExecute() {
        return this.dateStartExecute;
    }

    public Date getDateEndExecute() {
        return this.dateEndExecute;
    }

    public void setDateEndExecute(Date date) {
        this.dateEndExecute = date;
    }

    public Date getDateEndActivity() {
        return this.dateEndActivity;
    }

    public ActivityState getState() {
        return this.state;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public String getExecutionTime() {
        if (this.dateStartExecute != null) {
            Date dateTo = this.dateEndActivity == null ? new Date() : this.dateEndActivity;
            long diffInMillis = dateTo.getTime() - this.dateStartExecute.getTime();
            String timeFormat = QuantityFormatter.formatMillis(diffInMillis);
            return timeFormat;
        }
        return "0s";
    }

    public String toString() {
        return "id=" + this.id + " name=" + this.simpleName + " state=" + (Object)((Object)this.state);
    }
}

