/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.infos;

import ch.sharedvd.tipi.engine.action.UnknownProcess;
import ch.sharedvd.tipi.engine.infos.TipiActivityInfos;
import ch.sharedvd.tipi.engine.meta.MetaModelHelper;
import ch.sharedvd.tipi.engine.meta.TopProcessMetaModel;
import ch.sharedvd.tipi.engine.model.ActivityState;
import ch.sharedvd.tipi.engine.model.DbSubProcess;
import ch.sharedvd.tipi.engine.utils.Assert;
import java.util.Date;

public class TipiTopProcessInfos
extends TipiActivityInfos {
    private int priority = 0;
    private int nbThreads = 0;
    private int nbActivitesTotal = 0;
    private int nbActivitesInitial = 0;
    private int nbActivitesExecuting = 0;
    private int nbActivitesRetry = 0;
    private int nbActivitesRequestEndExecution = 0;
    private int nbActivitesFinished = 0;
    private int nbActivitesAborted = 0;
    private int nbActivitesError = 0;
    private int nbActivitesSuspended = 0;
    private int nbActivitesWaiting = 0;
    public Date dateStartTerminate;
    public Date dateEndTerminate;

    public TipiTopProcessInfos(DbSubProcess model, String description, boolean loadVariables) {
        super(model, description, loadVariables);
        this.dateStartTerminate = model.getDateStartTerminate();
        this.dateEndTerminate = model.getDateEndTerminate();
        TopProcessMetaModel meta = MetaModelHelper.getTopProcessMeta(model.getFqn());
        if (null != meta) {
            this.priority = meta.getPriority();
            this.nbThreads = meta.getNbMaxConcurrent();
            if (meta.getClazz().equals(UnknownProcess.class)) {
                this.setSimpleName("Unknown: " + this.getSimpleName());
                this.setProcessFqn("Unknown: " + this.getProcessFqn());
            }
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public int getNbThreads() {
        return this.nbThreads;
    }

    public int getNbActivitesInitial() {
        return this.nbActivitesInitial;
    }

    public void incNbActivitesInitial(int nbActivitesInitial) {
        this.nbActivitesInitial += nbActivitesInitial;
    }

    public int getNbActivitesExecuting() {
        return this.nbActivitesExecuting;
    }

    public void incNbActivitesExecuting(int nbActivitesExecuting) {
        this.nbActivitesExecuting += nbActivitesExecuting;
    }

    public int getNbActivitesRetry() {
        return this.nbActivitesRetry;
    }

    public void incNbActivitesRetry(int nbActivites) {
        this.nbActivitesRetry += nbActivites;
    }

    public int getNbActivitesRequestEndExecution() {
        return this.nbActivitesRequestEndExecution;
    }

    public void incNbActivitesRequestEndExecution(int nbActivitesRequestEndExecution) {
        this.nbActivitesRequestEndExecution += nbActivitesRequestEndExecution;
    }

    public int getNbActivitesFinished() {
        return this.nbActivitesFinished;
    }

    public void incNbActivitesFinished(int nbActivitesFinished) {
        this.nbActivitesFinished += nbActivitesFinished;
    }

    public int getNbActivitesAborted() {
        return this.nbActivitesAborted;
    }

    public void incNbActivitesAborted(int nbActivitesAborted) {
        this.nbActivitesAborted += nbActivitesAborted;
    }

    public int getNbActivitesError() {
        return this.nbActivitesError;
    }

    public void incNbActivitesError(int nbActivitesError) {
        this.nbActivitesError += nbActivitesError;
    }

    public int getNbActivitesSuspended() {
        return this.nbActivitesSuspended;
    }

    public void incNbActivitesSuspended(int nbActivitesSuspended) {
        this.nbActivitesSuspended += nbActivitesSuspended;
    }

    public int getNbActivitesWaiting() {
        return this.nbActivitesWaiting;
    }

    public void incNbActivitesWaiting(int nbActivitesWaiting) {
        this.nbActivitesWaiting += nbActivitesWaiting;
    }

    public int getNbActivitesTotal() {
        return this.nbActivitesTotal;
    }

    public void incNbActivitesTotal(int nbActivitesTotal) {
        this.nbActivitesTotal += nbActivitesTotal;
    }

    public Date getDateStartTerminate() {
        return this.dateStartTerminate;
    }

    public Date getDateEndTerminate() {
        return this.dateEndTerminate;
    }

    public void incActivitiesFromState(ActivityState aState, boolean aIsRequestEndExecution, int nbRetry) {
        ++this.nbActivitesTotal;
        if (nbRetry > 0) {
            ++this.nbActivitesRetry;
        }
        if (aIsRequestEndExecution) {
            ++this.nbActivitesRequestEndExecution;
        }
        switch (aState) {
            case INITIAL: {
                ++this.nbActivitesInitial;
                break;
            }
            case EXECUTING: {
                ++this.nbActivitesExecuting;
                break;
            }
            case ABORTED: {
                ++this.nbActivitesAborted;
                break;
            }
            case FINISHED: {
                ++this.nbActivitesFinished;
                break;
            }
            case ERROR: {
                ++this.nbActivitesError;
                break;
            }
            case WAIT_ON_CHILDREN: {
                ++this.nbActivitesWaiting;
                break;
            }
            case SUSPENDED: {
                ++this.nbActivitesSuspended;
                break;
            }
            default: {
                Assert.fail("Not impl");
            }
        }
    }
}

