/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.utils;

import ch.sharedvd.tipi.engine.utils.Assert;

public class QuantityFormatter {
    private static long BYTES_KB = 1024L;
    private static long BYTES_MB = BYTES_KB * 1024L;
    private static long BYTES_GB = BYTES_MB * 1024L;
    private static long BYTES_TB = BYTES_GB * 1024L;
    private static long BYTES_PB = BYTES_TB * 1024L;
    private static long SEC_IN_MILLIS = 1000L;
    private static long MIN_IN_MILLIS = 60L * SEC_IN_MILLIS;
    private static long HOUR_IN_MILLIS = MIN_IN_MILLIS * 60L;
    private static long DAY_IN_MILLIS = HOUR_IN_MILLIS * 24L;

    public static String formatMillis(long milliseconds) {
        String str;
        if (milliseconds > DAY_IN_MILLIS) {
            long days = milliseconds / DAY_IN_MILLIS;
            long daysInMillis = days * DAY_IN_MILLIS;
            long hours = (milliseconds - daysInMillis) / HOUR_IN_MILLIS;
            str = "" + days + "[d]" + hours + "[h]";
        } else if (milliseconds > HOUR_IN_MILLIS) {
            long hours = milliseconds / HOUR_IN_MILLIS;
            long hoursInMillis = hours * HOUR_IN_MILLIS;
            long mins = (milliseconds - hoursInMillis) / MIN_IN_MILLIS;
            str = "" + hours + "[h]" + mins + "[m]";
        } else if (milliseconds > MIN_IN_MILLIS) {
            long mins = milliseconds / MIN_IN_MILLIS;
            long minsInMillis = mins * MIN_IN_MILLIS;
            long secs = (milliseconds - minsInMillis) / SEC_IN_MILLIS;
            str = "" + mins + "[m]" + secs + "[s]";
        } else {
            str = milliseconds > SEC_IN_MILLIS ? QuantityFormatter.formatWithThreeSign((double)milliseconds / 1.0 / (double)SEC_IN_MILLIS) + "[s]" : QuantityFormatter.formatWithThreeSign(milliseconds) + "[ms]";
        }
        return str;
    }

    public static String formatBytes(long bytes) {
        String str;
        Assert.isTrue((bytes < BYTES_PB ? 1 : 0) != 0, (String)("Bytes : [" + bytes + "]"));
        if (bytes > BYTES_TB) {
            double gb = (double)bytes / 1.0 / (double)BYTES_TB;
            String value = QuantityFormatter.formatWithThreeSign(gb);
            str = value + "[Tb]";
        } else if (bytes > BYTES_GB) {
            double gb = (double)bytes / 1.0 / (double)BYTES_GB;
            String value = QuantityFormatter.formatWithThreeSign(gb);
            str = value + "[Gb]";
        } else if (bytes > BYTES_MB) {
            double mb = (double)bytes / 1.0 / (double)BYTES_MB;
            String value = QuantityFormatter.formatWithThreeSign(mb);
            str = value + "[Mb]";
        } else if (bytes > BYTES_KB) {
            double kb = (double)bytes / 1.0 / (double)BYTES_KB;
            String value = QuantityFormatter.formatWithThreeSign(kb);
            str = value + "[Kb]";
        } else {
            String value = QuantityFormatter.formatWithThreeSign(bytes);
            str = value + "[b]";
        }
        return str;
    }

    public static String formatWithThreeSign(double value) {
        Assert.isTrue((value <= 1024.0 ? 1 : 0) != 0);
        String str = value > 100.0 ? String.format("%d", (long)value) : (value > 10.0 ? String.format("%.1f", value) : (value > 1.0 ? String.format("%.2f", value) : String.format("%.3f", value)));
        return str;
    }
}

