/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.action;

import ch.sharedvd.tipi.engine.action.Activity;
import ch.sharedvd.tipi.engine.action.ActivityException;
import ch.sharedvd.tipi.engine.action.ActivityFacade;
import ch.sharedvd.tipi.engine.action.ActivityResultContext;
import ch.sharedvd.tipi.engine.action.ErrorActivityResultContext;
import ch.sharedvd.tipi.engine.action.FinishedActivityResultContext;
import ch.sharedvd.tipi.engine.client.VariableMap;
import ch.sharedvd.tipi.engine.meta.ActivityMetaModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public abstract class SubProcess
extends Activity {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubProcess.class);
    private boolean canAddChilren = true;

    public SubProcess() {
    }

    public SubProcess(ActivityFacade facade) {
        super(facade);
    }

    public final ActivityResultContext doTerminate() throws Exception {
        ActivityResultContext resultContext;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing activity: " + this.facade.getId() + ". Nom: " + this.facade.getName() + ". ");
        }
        try {
            this.canAddChilren = false;
            this.begin();
            resultContext = this.terminate();
        }
        catch (ActivityException e) {
            resultContext = new ErrorActivityResultContext("Type: " + e.getClass().getName() + ". Message: " + e.getMessage());
        }
        finally {
            try {
                this.end();
            }
            catch (Throwable t) {
                LOGGER.error("La m\u00e9thode end() a renvoy\u00e9 une exception!", t);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing activity: " + this.facade.getId() + ". Nom: " + this.facade.getName() + ". ");
        }
        return resultContext;
    }

    protected ActivityResultContext terminate() throws Exception {
        return new FinishedActivityResultContext();
    }

    protected long addChildActivity(Class<? extends Activity> clazz, VariableMap vars) {
        return this.addChildActivity(clazz, null, vars);
    }

    protected long addChildActivity(Class<? extends Activity> clazz, Long previousId, VariableMap vars) {
        Assert.isTrue((boolean)this.canAddChilren);
        return this.facade.addChildActivity(clazz, previousId, vars);
    }

    protected long addChildActivity(Class<? extends Activity> clazz, Long previousId, VariableMap vars, String correlationId) {
        Assert.isTrue((boolean)this.canAddChilren);
        return this.facade.addChildActivity(clazz, previousId, vars, correlationId);
    }

    protected long addChildActivity(ActivityMetaModel meta, VariableMap vars) {
        return this.addChildActivity(meta, null, vars);
    }

    protected long addChildActivity(ActivityMetaModel meta, Long previousId, VariableMap vars) {
        Assert.isTrue((boolean)this.canAddChilren);
        return this.facade.addChildActivity(meta, previousId, vars);
    }
}

