/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.client;

import ch.sharedvd.tipi.engine.client.AbstractRegistrar;
import ch.sharedvd.tipi.engine.client.ActivityRegistrar;
import ch.sharedvd.tipi.engine.client.TipiTopProcess;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class AnnotationActivityRegistrar
extends AbstractRegistrar
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActivityRegistrar.class);
    private String aPackage;
    private Collection<? extends TypeFilter> excludeFilters;

    public void setExcludeFilters(Collection<? extends TypeFilter> excludeFilters) {
        this.excludeFilters = excludeFilters;
    }

    public void afterPropertiesSet() throws Exception {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                return beanDefinition.getMetadata().isConcrete();
            }
        };
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(TipiTopProcess.class));
        if (this.excludeFilters != null) {
            for (TypeFilter typeFilter : this.excludeFilters) {
                scanner.addExcludeFilter(typeFilter);
            }
        }
        Set beans = scanner.findCandidateComponents(this.aPackage);
        LOGGER.info("Registering " + beans.size() + " Tipi activities");
        for (BeanDefinition bean : beans) {
            Class<?> clazz = Class.forName(bean.getBeanClassName());
            this.registerClass(clazz);
        }
    }

    public void setaPackage(String aPackage) {
        this.aPackage = aPackage;
    }
}

