/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.client;

import ch.sharedvd.tipi.engine.action.TopProcess;
import ch.sharedvd.tipi.engine.client.TipiFacade;
import ch.sharedvd.tipi.engine.client.VariableMap;
import ch.sharedvd.tipi.engine.command.CommandConsumer;
import ch.sharedvd.tipi.engine.command.CommandService;
import ch.sharedvd.tipi.engine.command.impl.AbortProcessCommand;
import ch.sharedvd.tipi.engine.command.impl.ColdRestartCommand;
import ch.sharedvd.tipi.engine.command.impl.RunExecutingActivitiesCommand;
import ch.sharedvd.tipi.engine.meta.MetaModelHelper;
import ch.sharedvd.tipi.engine.meta.TopProcessMetaModel;
import ch.sharedvd.tipi.engine.runner.ActivityRunningService;
import ch.sharedvd.tipi.engine.runner.TipiStarter;
import ch.sharedvd.tipi.engine.runner.TopProcessGroupManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TipiFacadeImpl
implements TipiFacade {
    private static final Logger log = LoggerFactory.getLogger(TipiFacadeImpl.class);
    @Autowired
    private CommandService commandService;
    @Autowired
    private TipiStarter starter;
    @Autowired
    private CommandConsumer commandConsumer;
    @Autowired
    private ActivityRunningService activityService;
    @Autowired
    private TopProcessGroupManager groupManager;

    @Override
    public void coldRestart() {
        this.commandConsumer.addCommand(new ColdRestartCommand());
    }

    @Override
    public boolean hasActivityPending() {
        return this.groupManager.hasActivityPending() || this.commandConsumer.hasCommandPending();
    }

    @Override
    public int getPendingCommandCount() {
        return this.commandConsumer.getPendingCommandCount();
    }

    @Override
    public boolean hasCommandPending() {
        return this.commandConsumer.hasCommandPending();
    }

    @Override
    public long launch(TopProcessMetaModel meta, VariableMap vars) {
        return this.activityService.launch(meta, vars);
    }

    @Override
    public long launch(Class<? extends TopProcess> cls, VariableMap vars) {
        return this.activityService.launch(cls, vars);
    }

    @Override
    public void resumeAllError() {
        this.activityService.resumeAllError();
    }

    @Override
    public void resumeErrors(String groupName) {
        this.activityService.resumeErrors(groupName);
    }

    @Override
    public void resumeAllSuspended() {
        this.activityService.resumeAllSuspended();
    }

    @Override
    public void resume(long id, VariableMap vars) {
        this.activityService.resume(id, vars);
    }

    @Override
    public boolean isRunning(long pid) {
        return this.activityService.isRunning(pid);
    }

    @Override
    public boolean isProcessRunning(long id) {
        return this.activityService.isProcessRunning(id);
    }

    @Override
    public boolean isProcessScheduled(long aid) {
        return this.activityService.isProcessScheduled(aid);
    }

    @Override
    public boolean isResumable(long pid) {
        return this.activityService.isResumable(pid);
    }

    @Override
    public void abortProcess(long pid, boolean delete) {
        this.commandService.sendCommand(new AbortProcessCommand(pid, delete));
    }

    @Override
    public void restartGroup(String fqn, int nbMax, int priority) throws Exception {
        TopProcessMetaModel group = MetaModelHelper.getTopProcessMeta(fqn);
        this.groupManager.restart(group, nbMax, priority);
        this.commandService.sendCommand(new RunExecutingActivitiesCommand());
    }

    @Override
    public void startGroup(String fqn) throws Exception {
        TopProcessMetaModel group = MetaModelHelper.getTopProcessMeta(fqn);
        this.groupManager.start(group);
        this.commandService.sendCommand(new RunExecutingActivitiesCommand());
    }

    @Override
    public void stopGroup(String fqn) throws Exception {
        TopProcessMetaModel group = MetaModelHelper.getTopProcessMeta(fqn);
        this.groupManager.stop(group);
    }

    @Override
    public void startAllGroups() throws Exception {
        this.groupManager.startAllGroups();
        this.commandService.sendCommand(new RunExecutingActivitiesCommand());
    }

    @Override
    public void stopAllGroups() throws Exception {
        this.groupManager.stopAllGroups();
    }

    @Override
    public boolean isTipiStarted() throws Exception {
        return this.starter.isStarted();
    }

    @Override
    public void startTipi() throws Exception {
        this.starter.start();
    }

    @Override
    public void stopTipi() throws Exception {
        this.starter.stop();
    }

    @Override
    public void setMaxConnections(String aConnectionType, int aNbMaxConnections) {
        this.activityService.setMaxConnections(aConnectionType, aNbMaxConnections);
    }

    @Override
    public void setMaxConcurrentActivitiesForGroup(String aGroupName, int aNbMaxConnections) {
        this.activityService.setMaxConcurrentActivitiesForGroup(aGroupName, aNbMaxConnections);
    }

    @Override
    public void setPriorityForGroup(String aGroupName, int aPrio) {
        this.activityService.setPriorityForGroup(aGroupName, aPrio);
    }
}

