/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.command.impl;

import ch.sharedvd.tipi.engine.command.impl.ActivityCommand;
import ch.sharedvd.tipi.engine.command.impl.RunExecutingActivitiesCommand;
import ch.sharedvd.tipi.engine.model.ActivityState;
import ch.sharedvd.tipi.engine.model.DbActivity;
import ch.sharedvd.tipi.engine.model.DbSubProcess;
import ch.sharedvd.tipi.engine.model.DbTopProcess;
import ch.sharedvd.tipi.engine.runner.ActivityStateChangeService;
import ch.sharedvd.tipi.engine.runner.TopProcessGroupLauncher;
import ch.sharedvd.tipi.engine.utils.Assert;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndActivityCommand
extends ActivityCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(EndActivityCommand.class);

    public EndActivityCommand(long aid) {
        super(aid);
    }

    @Override
    public void execute() {
        DbActivity finishedActivity = this.getModel();
        if (finishedActivity != null) {
            if (!finishedActivity.isRequestEndExecution()) {
                LOGGER.error("Activit\u00e9 " + finishedActivity.getId() + " en reqEnd = false!");
                return;
            }
            TopProcessGroupLauncher launcher = this.getLauncher();
            launcher.removeRunning(this.getActivityId());
            if (finishedActivity.getProcess() != null && finishedActivity.getProcess().isAborted()) {
                ActivityStateChangeService.aborted(finishedActivity);
                return;
            }
            if (finishedActivity.getState() == ActivityState.ERROR || finishedActivity.getState() == ActivityState.SUSPENDED) {
                ActivityStateChangeService.executionEnded(finishedActivity);
            } else {
                List<DbActivity> finishedActivityChildren = this.getChildren(finishedActivity);
                List<DbActivity> finishedActivityLaunchables = this.getLaunchableChildren(finishedActivityChildren);
                if (!finishedActivityLaunchables.isEmpty()) {
                    this.launchActivities(finishedActivityLaunchables);
                    ActivityStateChangeService.waitingOnChildren((DbSubProcess)finishedActivity);
                } else if (this.isAChildNotFinished(finishedActivityChildren)) {
                    Assert.isEqual((Object)ActivityState.WAIT_ON_CHILDREN, (Object)finishedActivity.getState());
                    ActivityStateChangeService.waitingOnChildren((DbSubProcess)finishedActivity);
                } else if (finishedActivity.getState() == ActivityState.WAIT_ON_CHILDREN) {
                    if (finishedActivityChildren.isEmpty()) {
                        ActivityStateChangeService.waitingOnChildren((DbSubProcess)finishedActivity);
                    }
                    ActivityStateChangeService.executingAfter(finishedActivity);
                } else {
                    Assert.isEqual((Object)ActivityState.FINISHED, (Object)finishedActivity.getState());
                    ActivityStateChangeService.executionEnded(finishedActivity);
                    if (finishedActivity instanceof DbTopProcess) {
                        StringBuilder msg = new StringBuilder("fin du process ");
                        msg.append(this.getMeta().getFQN()).append(" (").append(finishedActivity.getId()).append(") ");
                        if (finishedActivity.getDateEndActivity() != null && finishedActivity.getCreationDate() != null) {
                            long millis = finishedActivity.getDateEndActivity().getTime() - finishedActivity.getCreationDate().getTime();
                            msg.append(" (Duree: ").append(String.format("%.3f", (double)millis / 1000.0) + " [secs]").append(")");
                        }
                        LOGGER.debug(msg.toString());
                        if (this.getTopProcMeta().isDeleteWhenFinished()) {
                            this.activityService.deleteProcess((DbTopProcess)finishedActivity);
                        }
                    } else {
                        DbSubProcess parent = finishedActivity.getParent();
                        Assert.notNull((Object)parent);
                        Assert.isEqual((Object)ActivityState.FINISHED, (Object)finishedActivity.getState());
                        if (this.areAllOtherChildrenFinished(parent, finishedActivity)) {
                            ActivityStateChangeService.executingAfter(parent);
                        } else {
                            List<DbActivity> nexts = this.getNexts(finishedActivity);
                            if (nexts != null && !nexts.isEmpty()) {
                                this.launchActivities(nexts);
                            }
                        }
                    }
                }
            }
            this.commandService.sendCommand(new RunExecutingActivitiesCommand());
        }
    }

    private void launchActivities(List<DbActivity> aActis) {
        for (DbActivity act : aActis) {
            ActivityStateChangeService.executing(act);
        }
    }

    private List<DbActivity> getChildren(DbActivity aAct) {
        long diff;
        long begin = System.currentTimeMillis();
        ArrayList<DbActivity> ch = new ArrayList<DbActivity>();
        if (aAct instanceof DbSubProcess) {
            ch.addAll(this.activityRepository.findChildren(aAct));
        }
        if (!ch.isEmpty() && (diff = System.currentTimeMillis() - begin) > 100L && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Temps: " + diff + "[ms] pour " + ch.size() + " children de " + aAct.getId() + "/" + aAct.getFqn());
        }
        return ch;
    }

    private List<DbActivity> getLaunchableChildren(List<DbActivity> aChildren) {
        ArrayList<DbActivity> lch = new ArrayList<DbActivity>();
        for (DbActivity act : aChildren) {
            if (act.getState() != ActivityState.INITIAL || null != act.getPrevious()) continue;
            lch.add(act);
        }
        return lch;
    }

    private boolean isAChildNotFinished(List<DbActivity> aChildren) {
        boolean notFinished = false;
        for (DbActivity act : aChildren) {
            if (act.isTerminated()) continue;
            notFinished = true;
            break;
        }
        return notFinished;
    }

    private boolean areAllOtherChildrenFinished(DbSubProcess aSub, DbActivity finishedActivity) {
        long begin = System.currentTimeMillis();
        String hql = "select count(*) from DbActivity a where a.parent = :parent    and a <> :act    and not (a.state = :state and a.requestEndExecution = false)";
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("HQL: " + hql);
        }
        Query q = this.em.createQuery(hql);
        q.setParameter("parent", (Object)aSub);
        q.setParameter("act", (Object)finishedActivity);
        q.setParameter("state", (Object)ActivityState.FINISHED);
        Long notFinished = (Long)q.getSingleResult();
        long diff = System.currentTimeMillis() - begin;
        if (diff > 100L && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Temps: " + diff + "[ms] pour savoir s'il reste des children a !FINISHED de " + aSub.getId() + "/" + aSub.getFqn());
        }
        return notFinished == 0L;
    }

    private List<DbActivity> getNexts(DbActivity aAct) {
        String hql = "from DbActivity a where a.previous = :previous    and a.state = :state";
        Query q = this.em.createQuery(hql);
        q.setParameter("previous", (Object)aAct);
        q.setParameter("state", (Object)ActivityState.INITIAL);
        List nexts = q.getResultList();
        return nexts;
    }
}

