/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.command.impl;

import ch.sharedvd.tipi.engine.command.Command;
import ch.sharedvd.tipi.engine.model.ActivityState;
import ch.sharedvd.tipi.engine.model.DbActivity;
import ch.sharedvd.tipi.engine.runner.ActivityStateChangeService;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ResumeAllActivitiesCommand
extends Command {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResumeAllActivitiesCommand.class);
    @Autowired
    private EntityManager em;
    private ActivityState state;
    private String groupName;

    public ResumeAllActivitiesCommand(ActivityState state) {
        this.state = state;
    }

    public ResumeAllActivitiesCommand(ActivityState state, String gname) {
        this.state = state;
        this.groupName = gname;
    }

    public List<DbActivity> getActivities() {
        List<DbActivity> models = StringUtils.isNotBlank((CharSequence)this.groupName) ? this.activityRepository.findByGroupAndState(this.groupName, this.state) : this.activityRepository.findByState(this.state);
        return models;
    }

    @Override
    public void execute() {
        List<DbActivity> models = this.getActivities();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Trouv\u00e9 " + models.size() + " activit\u00e9s a resumer");
        }
        for (DbActivity acti : models) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Resuming activity " + acti.getId() + " / " + acti.getFqn());
            }
            ActivityStateChangeService.resuming(acti);
            this.runActivity(acti);
        }
    }
}

