/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.infos;

import ch.sharedvd.tipi.engine.infos.RunningProcessesData;
import ch.sharedvd.tipi.engine.runner.TopProcessGroupLauncher;
import java.io.Serializable;

public class TopProcessGroupInfos
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long nbActivitesInitial = 0L;
    private long nbActivitesExecuting = 0L;
    private long nbActivitesFinished = 0L;
    private long nbActivitesSuspended = 0L;
    private long nbActivitesWaitChildren = 0L;
    private long nbActivitesAborted = 0L;
    private long nbActivitesError = 0L;
    private long nbActivitesWithReqEnd = 0L;
    private long nbActivitesWithRetryCount = 0L;
    private int nbMaxConcurrent;
    private int nbActivitesCurrentlyExecuting;
    private boolean started;
    private int priority;
    private String name;
    private String simpleName;

    public TopProcessGroupInfos(String aFqn, String simpleName, TopProcessGroupLauncher launcher) {
        this.name = aFqn;
        this.simpleName = simpleName;
        this.nbMaxConcurrent = null == launcher ? -1 : launcher.getNbMaxConcurrentActivities();
        this.nbActivitesCurrentlyExecuting = null == launcher ? -1 : launcher.getRunningCount();
        this.started = null == launcher ? false : launcher.isStarted();
        this.priority = null == launcher ? -1 : launcher.getPriority();
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getName() {
        return this.name;
    }

    public int getNbMaxConcurrent() {
        return this.nbMaxConcurrent;
    }

    public long getNbActivitesCurrentlyExecuting() {
        return this.nbActivitesCurrentlyExecuting;
    }

    public boolean isStarted() {
        return this.started;
    }

    public int getPriority() {
        return this.priority;
    }

    public long getNbActivitesInitial() {
        return this.nbActivitesInitial;
    }

    public void setNbActivitesInitial(long nbActivitesInitial) {
        this.nbActivitesInitial = nbActivitesInitial;
    }

    public long getNbActivitesExecuting() {
        return this.nbActivitesExecuting;
    }

    public void setNbActivitesExecuting(long nbActivitesExecuting) {
        this.nbActivitesExecuting = nbActivitesExecuting;
    }

    public long getNbActivitesWithRetryCount() {
        return this.nbActivitesWithRetryCount;
    }

    public void setNbActivitesWithRetryCount(long nbActivitesWithRetryCount) {
        this.nbActivitesWithRetryCount = nbActivitesWithRetryCount;
    }

    public long getNbActivitesFinished() {
        return this.nbActivitesFinished;
    }

    public void setNbActivitesFinished(long nbActivitesFinished) {
        this.nbActivitesFinished = nbActivitesFinished;
    }

    public long getNbActivitesWaitChildren() {
        return this.nbActivitesWaitChildren;
    }

    public void setNbActivitesWaitChildren(long nbActivitesWaitChildren) {
        this.nbActivitesWaitChildren = nbActivitesWaitChildren;
    }

    public long getNbActivitesSuspended() {
        return this.nbActivitesSuspended;
    }

    public void setNbActivitesSuspended(long nbActivitesSuspended) {
        this.nbActivitesSuspended = nbActivitesSuspended;
    }

    public long getNbActivitesAborted() {
        return this.nbActivitesAborted;
    }

    public void setNbActivitesAborted(long nb) {
        this.nbActivitesAborted = nb;
    }

    public long getNbActivitesError() {
        return this.nbActivitesError;
    }

    public void setNbActivitesError(long nbActivitesError) {
        this.nbActivitesError = nbActivitesError;
    }

    public long getNbActivitesWithReqEnd() {
        return this.nbActivitesWithReqEnd;
    }

    public void setNbActivitesWithReqEnd(long aNbActivitesWithReqEnd) {
        this.nbActivitesWithReqEnd = aNbActivitesWithReqEnd;
    }

    public void incrementWithData(RunningProcessesData process) {
        this.nbActivitesError += (long)process.getErrorCount();
        this.nbActivitesExecuting += (long)process.getExecutingCount();
        this.nbActivitesFinished += (long)process.getFinishCount();
        this.nbActivitesInitial += (long)process.getInitialCount();
        this.nbActivitesAborted += (long)process.getAbortCount();
        this.nbActivitesSuspended += (long)process.getSuspendedCount();
        this.nbActivitesWaitChildren += (long)process.getWaitCount();
        this.nbActivitesWithReqEnd += (long)process.getReqEndCount();
        this.nbActivitesWithRetryCount += (long)process.getRetryCount();
    }
}

