/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.model;

import ch.sharedvd.tipi.engine.model.ActivityState;
import ch.sharedvd.tipi.engine.model.DbBaseEntity;
import ch.sharedvd.tipi.engine.model.DbSubProcess;
import ch.sharedvd.tipi.engine.model.DbTopProcess;
import ch.sharedvd.tipi.engine.model.DbVariable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;

@Entity
@NamedQueries(value={@NamedQuery(name="DbActivity.findExecutingActivities", query="select a from DbActivity a where (a.process in (from DbTopProcess p where p.fqn = (?1))        or a in (from DbTopProcess p where p.fqn = (?1)) )    and a.state = ch.sharedvd.tipi.engine.model.ActivityState.EXECUTING    and a.requestEndExecution = false order by nbRetryDone asc, id asc"), @NamedQuery(name="DbActivity.findChildren", query="from DbActivity a where a.parent = (?1)"), @NamedQuery(name="DbActivity.findByGroupAndState", query="select a from DbActivity a left join a.process p where (    p in (select pi from DbTopProcess pi where pi.fqn = (?1))            or a.fqn = (?1)       )  and a.requestEndExecution = false   and a.state = (?2)"), @NamedQuery(name="DbActivity.findByState", query="select a from DbActivity a where a.requestEndExecution = false   and a.state = (?1)")})
@Table(name="TP_ACTIVITY", indexes={@Index(name="TP_ACT_REQEND_STATE_IDX", columnList="STATE,REQUEST_END_EXECUTION"), @Index(name="TP_ACT_DTYPE_IDX", columnList="DTYPE"), @Index(name="TP_ACT_PARENT_FK_IDX", columnList="PARENT_FK"), @Index(name="TP_ACT_PROCESS_FK_IDX", columnList="PROCESS_FK"), @Index(name="TP_ACT_FQN_IDX", columnList="FQN"), @Index(name="TP_ACTIVITY_CORRELATION_IDX", columnList="CORRELATION_ID"), @Index(name="TP_ACTIVITY_STATE_IDX", columnList="STATE"), @Index(name="TP_ACTIVITY_REQUEST_END_EXEC", columnList="REQUEST_END_EXECUTION"), @Index(name="TP_ACT_PREVIOUS_FK_IDX", columnList="PREVIOUS_FK")})
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn
@DiscriminatorValue(value="activity")
public class DbActivity
extends DbBaseEntity {
    @Column(name="FQN", nullable=false)
    private String fqn;
    @Column(name="PROCESS_NAME", nullable=false)
    private String processName;
    @Column(name="STATE", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private ActivityState state;
    @OneToMany(mappedBy="process")
    private List<DbActivity> children;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PROCESS_FK", nullable=true)
    @OnDelete(action=OnDeleteAction.CASCADE)
    private DbTopProcess process;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PARENT_FK", nullable=true)
    @OnDelete(action=OnDeleteAction.CASCADE)
    private DbSubProcess parent;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PREVIOUS_FK", nullable=true)
    @OnDelete(action=OnDeleteAction.CASCADE)
    private DbActivity previous;
    @OneToMany(mappedBy="owner", cascade={CascadeType.ALL}, orphanRemoval=true)
    @MapKey(name="key")
    @OnDelete(action=OnDeleteAction.CASCADE)
    private Map<String, DbVariable<?>> variables = new HashMap();
    @Column(name="DATE_START_EXECUTE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateStartExecute;
    @Column(name="DATE_END_EXECUTE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateEndExecute;
    @Column(name="DATE_END_ACTIVITY")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateEndActivity;
    @Column(name="CORRELATION_ID")
    private String correlationId;
    @Column(name="REQUEST_END_EXECUTION", nullable=false)
    private boolean requestEndExecution = false;
    @Column(name="NB_RETRY", nullable=false)
    private int nbRetryDone = 0;
    @Column(name="CALLSTACK", length=2000)
    private String callstack;
    static final String FIND_BY_STATE = "select a from DbActivity a where a.requestEndExecution = false   and a.state = (?1)";
    static final String FIND_GROUP_STATE = "select a from DbActivity a left join a.process p where (    p in (select pi from DbTopProcess pi where pi.fqn = (?1))            or a.fqn = (?1)       )  and a.requestEndExecution = false   and a.state = (?2)";
    static final String FIND_CHILDREN = "from DbActivity a where a.parent = (?1)";
    static final String FIND_EXEC_ACTIVITIES = "select a from DbActivity a where (a.process in (from DbTopProcess p where p.fqn = (?1))        or a in (from DbTopProcess p where p.fqn = (?1)) )    and a.state = ch.sharedvd.tipi.engine.model.ActivityState.EXECUTING    and a.requestEndExecution = false order by nbRetryDone asc, id asc";

    public DbActivity() {
        this.state = ActivityState.INITIAL;
    }

    public DbTopProcess getProcess() {
        return this.process;
    }

    public void setProcess(DbTopProcess process) {
        this.process = process;
        if (process != null) {
            this.setProcessName(process.getFqn());
        }
    }

    public DbSubProcess getParent() {
        return this.parent;
    }

    public void setParent(DbSubProcess parent) {
        this.parent = parent;
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public DbActivity getPrevious() {
        return this.previous;
    }

    public void setPrevious(DbActivity previous) {
        this.previous = previous;
    }

    public boolean isRequestEndExecution() {
        return this.requestEndExecution;
    }

    public void setRequestEndExecution(boolean aRequestEndExecution) {
        this.requestEndExecution = aRequestEndExecution;
    }

    public int getNbRetryDone() {
        return this.nbRetryDone;
    }

    public void setNbRetryDone(int nbRetryDone) {
        this.nbRetryDone = nbRetryDone;
    }

    public String getFqn() {
        return this.fqn;
    }

    public void setFqn(String name) {
        this.fqn = name;
    }

    public Date getDateStartExecute() {
        return this.dateStartExecute;
    }

    public void setDateStartExecute(Date aDateStartExecute) {
        this.dateStartExecute = aDateStartExecute;
    }

    public Date getDateEndExecute() {
        return this.dateEndExecute;
    }

    public void setDateEndExecute(Date aDateEndExecute) {
        this.dateEndExecute = aDateEndExecute;
    }

    public Date getDateEndActivity() {
        return this.dateEndActivity;
    }

    public void setDateEndActivity(Date dateEndActivity) {
        this.dateEndActivity = dateEndActivity;
    }

    public ActivityState getState() {
        return this.state;
    }

    public void setState(ActivityState state) {
        this.state = state;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String aCorrelationId) {
        this.correlationId = aCorrelationId;
    }

    public String getCallstack() {
        return this.callstack;
    }

    public void setCallstack(String cs) {
        this.callstack = cs != null && cs.length() > 2000 ? cs.substring(0, 2000) : cs;
    }

    private Map<String, DbVariable<?>> getVariables() {
        return this.variables;
    }

    private void setVariables(Map<String, DbVariable<?>> variables) {
        this.variables = variables;
    }

    public void putVariable(DbVariable<?> aVar) {
        if (this.variables.get(aVar.getKey()) != null) {
            this.toString();
        }
        this.variables.put(aVar.getKey(), aVar);
    }

    @Transient
    public void removeVariable(String key) {
        this.getVariables().size();
        this.getVariables().remove(key);
    }

    @Transient
    public Object getVariable(String key) {
        DbVariable<?> var = this.getVariables().get(key);
        if (var != null) {
            return var.getValue();
        }
        return null;
    }

    @Transient
    public Map<String, Object> getAllVariables() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        for (String key : this.getVariables().keySet()) {
            Object value = this.getVariable(key);
            if (value == null) continue;
            vars.put(key, value);
        }
        return vars;
    }

    @Transient
    public boolean containsVariable(String key) {
        return this.getVariables().containsKey(key);
    }

    @Transient
    public boolean isTerminated() {
        return !this.isRequestEndExecution() && ActivityState.FINISHED.equals((Object)this.getState());
    }

    @Transient
    public boolean isAborted() {
        return !this.isRequestEndExecution() && ActivityState.ABORTED.equals((Object)this.getState());
    }

    @Transient
    public boolean isTerminatedWithError() {
        return ActivityState.ERROR.equals((Object)this.getState()) && !this.isRequestEndExecution();
    }

    @Transient
    public boolean isTerminatedSuspended() {
        return ActivityState.SUSPENDED.equals((Object)this.getState()) && !this.isRequestEndExecution();
    }

    @Transient
    public boolean isResumable() {
        return this.isTerminatedWithError() || this.isTerminatedSuspended();
    }

    @Transient
    public boolean isRepeatable() {
        return ActivityState.EXECUTING.equals((Object)this.getState()) && !this.isRequestEndExecution();
    }

    @Transient
    public String getSimpleName() {
        if (this.fqn.contains(".")) {
            String[] splitedName = this.fqn.split("\\.");
            int index = splitedName != null && splitedName.length > 0 ? splitedName.length - 1 : 0;
            String simpleName = splitedName[index];
            return simpleName;
        }
        return this.fqn;
    }

    @Transient
    public DbTopProcess getProcessOrThis() {
        if (this.process == null) {
            return (DbTopProcess)this;
        }
        return this.process;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("name=").append(this.fqn);
        str.append(",processName=").append(this.getProcessName());
        str.append(",parent=");
        if (this.parent != null) {
            str.append(this.parent.getId());
        } else {
            str.append("null");
        }
        str.append(",state=").append((Object)this.getState());
        str.append(",reqEnd=").append(this.requestEndExecution);
        str.append(",retry=").append(this.getNbRetryDone());
        return super.toString(str.toString());
    }
}

