/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.model;

import ch.sharedvd.tipi.engine.model.DbVariable;
import ch.sharedvd.tipi.engine.utils.BlobFactory;
import ch.sharedvd.tipi.engine.utils.InputStreamHolder;
import java.io.InputStream;
import java.sql.Blob;
import java.util.zip.DeflaterInputStream;
import java.util.zip.InflaterInputStream;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import org.apache.commons.io.IOUtils;

@Entity
@DiscriminatorValue(value="file")
public class DbInputStreamVariable
extends DbVariable<InputStreamHolder> {
    @Column(name="BLOB_VALUE")
    private Blob blob;
    private transient InputStreamHolder deserialBlob = null;

    protected DbInputStreamVariable() {
    }

    public DbInputStreamVariable(String key, InputStreamHolder value, BlobFactory aBlobFactory) {
        super(key);
        this.setValue(value, aBlobFactory);
    }

    public Blob getBlob() {
        return this.blob;
    }

    public void setBlob(Blob b) {
        this.blob = b;
    }

    @Override
    @Transient
    public InputStreamHolder getValue() {
        if (this.deserialBlob == null) {
            if (this.getBlob() != null) {
                InflaterInputStream inputStream = null;
                InputStream binaryStream = null;
                try {
                    if (this.getBlob().length() > 0L) {
                        binaryStream = this.getBlob().getBinaryStream();
                        inputStream = new InflaterInputStream(binaryStream);
                        this.deserialBlob = new InputStreamHolder(inputStream);
                        return this.deserialBlob;
                    }
                }
                catch (Exception e) {
                    IOUtils.closeQuietly(inputStream);
                    IOUtils.closeQuietly(binaryStream);
                    String msg = "Impossible de lire le blob";
                    throw new RuntimeException(msg, e);
                }
            }
            return null;
        }
        return this.deserialBlob;
    }

    public void setValue(InputStreamHolder is, BlobFactory aBlobFactory) {
        this.deserialBlob = null;
        try (DeflaterInputStream inputStream = new DeflaterInputStream(is.getInputStream());){
            this.setBlob(aBlobFactory.createBlob(inputStream));
        }
        catch (Exception e) {
            String msg = "Impossible de mettre \u00e0 jour le blob";
            throw new RuntimeException(msg, e);
        }
    }
}

