/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.query;

import ch.sharedvd.tipi.engine.infos.ActivityThreadInfos;
import ch.sharedvd.tipi.engine.infos.ConnectionCapInfos;
import ch.sharedvd.tipi.engine.infos.TipiActivityInfos;
import ch.sharedvd.tipi.engine.infos.TipiTopProcessInfos;
import ch.sharedvd.tipi.engine.meta.MetaModelHelper;
import ch.sharedvd.tipi.engine.meta.TopProcessMetaModel;
import ch.sharedvd.tipi.engine.model.ActivityState;
import ch.sharedvd.tipi.engine.model.DbActivity;
import ch.sharedvd.tipi.engine.model.DbSubProcess;
import ch.sharedvd.tipi.engine.model.DbTopProcess;
import ch.sharedvd.tipi.engine.query.HqlQuery;
import ch.sharedvd.tipi.engine.query.TipiCriteria;
import ch.sharedvd.tipi.engine.repository.ActivityRepository;
import ch.sharedvd.tipi.engine.runner.ConnectionCap;
import ch.sharedvd.tipi.engine.runner.ConnectionCapManager;
import ch.sharedvd.tipi.engine.runner.TopProcessGroupManager;
import ch.sharedvd.tipi.engine.utils.Assert;
import ch.sharedvd.tipi.engine.utils.ResultListWithCount;
import ch.sharedvd.tipi.engine.utils.TixTemplate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ActivityQueryService {
    @Autowired
    private TixTemplate txTemplate;
    @Autowired
    private ActivityRepository activityRepository;
    @Autowired
    private EntityManager em;
    @Autowired
    private ConnectionCapManager connectionCapManager;
    @Autowired
    private TopProcessGroupManager topProcessGroupManager;

    public List<Long> getActivitiesForCorrelationId(String aCorrelationId) {
        HqlQuery hq = new HqlQuery();
        hq.select("a.id");
        hq.from("DbActivity a");
        hq.where("a.correlationId = :correlationId", "correlationId", aCorrelationId);
        return hq.getResultList(this.em);
    }

    public TipiActivityInfos getActivityInfos(long id, boolean loadVariables) {
        TipiActivityInfos infos = this.txTemplate.txWith(s -> {
            DbActivity am = (DbActivity)this.activityRepository.findOne(Long.valueOf(id));
            return this.buildActivityOrProcessInfos(am, loadVariables, true);
        });
        return infos;
    }

    public ResultListWithCount<TipiActivityInfos> searchActivities(TipiCriteria criteria, int maxHits) {
        ResultListWithCount infos = this.txTemplate.txWith(s -> {
            HqlQuery hq = this.generateCriteria(criteria);
            ResultListWithCount results = hq.getResultListWithCount(this.em, maxHits);
            ArrayList<TipiActivityInfos> list = new ArrayList<TipiActivityInfos>();
            for (DbActivity am : results.getResult()) {
                list.add(this.buildActivityOrProcessInfos(am, false, false));
            }
            ResultListWithCount l = new ResultListWithCount(list, results.getCount());
            return l;
        });
        return infos;
    }

    private HqlQuery generateCriteria(TipiCriteria criteria) {
        HqlQuery hq = new HqlQuery();
        hq.select("a");
        hq.from("DbActivity a");
        hq.where("1 = 1 ");
        if (criteria.getProcessId() != null) {
            hq.where(" and (a.process.id = :processId or a.id = :processId) ", "processId", criteria.getProcessId());
        }
        if (criteria.getParentId() != null) {
            hq.where(" and a.parent.id = :parentId ", "parentId", criteria.getParentId());
        }
        if (criteria.getId() != null) {
            hq.where(" and a.id = :id ", "id", criteria.getId());
        }
        if (StringUtils.isNotBlank((CharSequence)criteria.getNameOrProcessName())) {
            String processName = criteria.getNameOrProcessName();
            hq.where(" and a.processName like '%:id' ", "processName", processName);
        }
        if (criteria.getDemandeFinExecution() != null) {
            hq.where(" and a.requestEndExecution = :reqEnd ", "reqEnd", criteria.getDemandeFinExecution());
        }
        if (criteria.getStatesSelectionnes() != null && criteria.getStatesSelectionnes().length >= 1) {
            hq.where(" and a.state in (:state) ", "state", criteria.getStatesSelectionnes());
        }
        if (StringUtils.isNotBlank((CharSequence)criteria.getIdCorrelation())) {
            hq.where(" and a.correlationId = :correlationId ", "correlationId", criteria.getIdCorrelation());
        }
        if (StringUtils.isNotBlank((CharSequence)criteria.getVariableName()) && criteria.getVariableValue() != null) {
            hq.from("join a.variables vars");
            hq.where("and vars.key = :varkey", "varkey", criteria.getVariableName());
            if (criteria.getVariableValue() instanceof Long) {
                hq.where("and vars.longValue = :varvalue", "varvalue", criteria.getVariableValue());
            } else if (criteria.getVariableValue() instanceof String) {
                hq.where("and vars.stringValue = :varvalue", "varvalue", criteria.getVariableValue());
            } else {
                Assert.fail("Other variable types to implement");
            }
        } else if (StringUtils.isNotBlank((CharSequence)criteria.getVariableName())) {
            hq.from("join a.variables vars");
            hq.where("and vars.key = :varkey", "varkey", criteria.getVariableName());
        }
        hq.order("a.creation");
        return hq;
    }

    private TipiActivityInfos buildActivityOrProcessInfos(DbActivity am, boolean loadVariables, boolean gatherChildActivities) {
        if (null == am) {
            return null;
        }
        if (am instanceof DbSubProcess) {
            return this.getRunningProcessInfos((DbSubProcess)am, loadVariables, gatherChildActivities);
        }
        TopProcessMetaModel meta = MetaModelHelper.getTopProcessMeta(am.getFqn());
        return new TipiActivityInfos(am, meta.getDescription(), loadVariables);
    }

    private TipiTopProcessInfos getRunningProcessInfos(DbSubProcess process, boolean loadVariables, boolean gatherChildActivities) {
        TopProcessMetaModel meta = MetaModelHelper.getTopProcessMeta(process.getFqn());
        TipiTopProcessInfos infos = new TipiTopProcessInfos(process, meta.getDescription(), loadVariables);
        if (process instanceof DbTopProcess) {
            infos.incActivitiesFromState(process.getState(), process.isRequestEndExecution(), process.getNbRetryDone());
        }
        if (gatherChildActivities && process instanceof DbTopProcess) {
            long pid = process.getId();
            this.updateDateFinExecution(infos, this.getOlderProcessEndExecution(pid, false));
            infos.incNbActivitesTotal(this.countActivitiesByState(pid, null, false));
            infos.incNbActivitesInitial(this.countActivitiesByState(pid, ActivityState.INITIAL, false));
            infos.incNbActivitesExecuting(this.countActivitiesByState(pid, ActivityState.EXECUTING, false));
            infos.incNbActivitesRetry(this.countActivitiesRetry(pid, false));
            infos.incNbActivitesAborted(this.countActivitiesByState(pid, ActivityState.ABORTED, false));
            infos.incNbActivitesFinished(this.countActivitiesByState(pid, ActivityState.FINISHED, false));
            infos.incNbActivitesError(this.countActivitiesByState(pid, ActivityState.ERROR, false));
            infos.incNbActivitesWaiting(this.countActivitiesByState(pid, ActivityState.WAIT_ON_CHILDREN, false));
            infos.incNbActivitesSuspended(this.countActivitiesByState(pid, ActivityState.SUSPENDED, false));
            infos.incNbActivitesRequestEndExecution(this.countActivitiesRequestEndExecution(pid, false));
        }
        return infos;
    }

    public Date getOlderProcessEndExecution(Long processId, boolean subProcessOnly) {
        Date infos = this.txTemplate.txWith(s -> {
            HqlQuery hq = new HqlQuery();
            hq.select("count(*)");
            hq.from("DbActivity a");
            this.addSubProcessExpr(hq, processId, subProcessOnly);
            hq.where(" and a.dateEndExecute is not null");
            List resultSet = hq.getResultList(this.em);
            if (resultSet.size() == 1) {
                return null;
            }
            hq = new HqlQuery();
            hq.select("count(*)");
            hq.from("DbActivity a");
            this.addSubProcessExpr(hq, processId, subProcessOnly);
            hq.where(" and a.dateEndExecute = true");
            resultSet = hq.getResultList(this.em);
            if (resultSet.size() == 1) {
                DbActivity am = (DbActivity)resultSet.get(0);
                return am.getDateEndExecute();
            }
            return null;
        });
        return infos;
    }

    public List<ActivityThreadInfos> getThreadsInfos() {
        return this.topProcessGroupManager.getThreadsInfos();
    }

    public List<ConnectionCapInfos> getAllConnectionCupInfos() {
        ArrayList<ConnectionCapInfos> connCupInfos = new ArrayList<ConnectionCapInfos>();
        for (ConnectionCap ct : this.connectionCapManager.getCaps()) {
            connCupInfos.add(new ConnectionCapInfos(ct, this.connectionCapManager));
        }
        return connCupInfos;
    }

    public ResultListWithCount<TipiTopProcessInfos> getRunningProcesses(int maxHits) {
        return this.txTemplate.txWith(s -> {
            HqlQuery hq = new HqlQuery();
            hq.from("DbTopProcess p");
            hq.where("p.parent.id is null ");
            hq.where(" and p.state in :state", "state", Arrays.asList(ActivityState.INITIAL, ActivityState.EXECUTING, ActivityState.WAIT_ON_CHILDREN));
            hq.order("creation desc");
            ResultListWithCount results = hq.getResultListWithCount(this.em, maxHits);
            ArrayList<TipiTopProcessInfos> list = new ArrayList<TipiTopProcessInfos>();
            for (DbTopProcess am : results) {
                TipiTopProcessInfos i = this.getRunningProcessInfos(am, false, true);
                list.add(i);
            }
            return new ResultListWithCount(list, results.getCount());
        });
    }

    public ResultListWithCount<TipiTopProcessInfos> getAllProcesses(int maxHits) {
        ResultListWithCount infos = this.txTemplate.txWith(s -> {
            TipiTopProcessInfos i;
            ArrayList<TipiTopProcessInfos> list = new ArrayList<TipiTopProcessInfos>();
            int count = 0;
            HqlQuery hq = new HqlQuery();
            hq.from("DbTopProcess p");
            hq.where("p.parent.id is null");
            hq.where(" and p.state in :state", "state", Arrays.asList(ActivityState.ABORTED, ActivityState.FINISHED));
            hq.order("creation asc");
            ResultListWithCount results = hq.getResultListWithCount(this.em, maxHits);
            count = (int)((long)count + results.getCount());
            for (DbActivity am : results.getResult()) {
                i = this.getRunningProcessInfos((DbTopProcess)am, false, true);
                list.add(i);
            }
            hq = new HqlQuery();
            hq.from("DbTopProcess p");
            hq.where("p.parent.id is null");
            hq.where(" and p.state NOT in :state", "state", Arrays.asList(ActivityState.ABORTED, ActivityState.FINISHED));
            hq.order("creation desc");
            results = hq.getResultListWithCount(this.em, maxHits);
            count = (int)((long)count + results.getCount());
            for (DbActivity am : results.getResult()) {
                i = this.getRunningProcessInfos((DbTopProcess)am, false, true);
                list.add(i);
            }
            return new ResultListWithCount(list, count);
        });
        return infos;
    }

    public int countActivitiesByState(Long processId, ActivityState state, boolean subProcessOnly) {
        int infos = this.txTemplate.txWith(s -> {
            HqlQuery hq = new HqlQuery("count(*)", "DbActivity a");
            this.addSubProcessExpr(hq, processId, subProcessOnly);
            if (state != null) {
                hq.where(" and state = :state", "state", (Object)state);
            }
            int result = ((Long)hq.getSingleResult(this.em)).intValue();
            return result;
        });
        return infos;
    }

    public int countActivitiesRequestEndExecution(Long processId, boolean subProcessOnly) {
        int infos = this.txTemplate.txWith(s -> {
            HqlQuery hq = new HqlQuery("count(*)", "DbActivity a");
            this.addSubProcessExpr(hq, processId, subProcessOnly);
            hq.where(" and a.requestEndExecution = true");
            int result = ((Long)hq.getSingleResult(this.em)).intValue();
            return result;
        });
        return infos;
    }

    public int countActivitiesRetry(Long processId, boolean subProcessOnly) {
        int infos = this.txTemplate.txWith(s -> {
            HqlQuery hq = new HqlQuery("count(*)", "DbActivity a");
            this.addSubProcessExpr(hq, processId, subProcessOnly);
            hq.where(" and a.nbRetryDone > 0");
            int result = ((Long)hq.getSingleResult(this.em)).intValue();
            return result;
        });
        return infos;
    }

    private HqlQuery addSubProcessExpr(HqlQuery hq, Long processId, boolean subProcessOnly) {
        if (subProcessOnly) {
            hq.where(" a.parent.id = :parentId ", "parentId", processId);
        } else {
            hq.where(" a.process.id = :processId ", "processId", processId);
        }
        return hq;
    }

    private void updateDateFinExecution(TipiTopProcessInfos aInfos, Date aChildDate) {
        if (null != aInfos.getDateEndExecute() && null != aChildDate && aInfos.getDateEndExecute().before(aChildDate)) {
            aInfos.setDateEndExecute(aChildDate);
        }
    }
}

