/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.registry;

import ch.sharedvd.tipi.engine.action.TopProcess;
import ch.sharedvd.tipi.engine.meta.TopProcessMetaModel;
import ch.sharedvd.tipi.engine.registry.TipiRegistry;
import ch.sharedvd.tipi.engine.utils.Assert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TipiRegistryImpl
implements TipiRegistry {
    private Map<String, TopProcessMetaModel> topProcess = new HashMap<String, TopProcessMetaModel>();
    private Listener listener;

    @Override
    public void register(TopProcessMetaModel tp) {
        Assert.notNull((Object)tp);
        Assert.notNull((Object)tp.getSimpleName());
        TopProcessMetaModel existing = this.topProcess.get(tp.getSimpleName());
        if (existing == null) {
            this.topProcess.put(tp.getFQN(), tp);
            if (this.listener != null) {
                this.listener.registered(tp);
            }
        } else if (tp != existing) {
            Assert.isTrue((tp == existing ? 1 : 0) != 0);
        }
    }

    @Override
    public TopProcessMetaModel getTopProcess(Class<? extends TopProcess> clazz) {
        return this.getTopProcess(clazz.getSimpleName());
    }

    @Override
    public TopProcessMetaModel getTopProcess(String name) {
        TopProcessMetaModel tpmm = this.topProcess.get(name);
        if (tpmm == null) {
            for (String key : this.topProcess.keySet()) {
                if (!key.endsWith(name)) continue;
                return this.topProcess.get(key);
            }
        }
        return tpmm;
    }

    @Override
    public List<TopProcessMetaModel> getAllTopProcesses() {
        return new ArrayList<TopProcessMetaModel>(this.topProcess.values());
    }

    @Override
    public List<TopProcessMetaModel> getAllTopProcessesForUI() {
        ArrayList<TopProcessMetaModel> availables = new ArrayList<TopProcessMetaModel>();
        for (TopProcessMetaModel meta : this.topProcess.values()) {
            if (!meta.isShownInUI()) continue;
            availables.add(meta);
        }
        Collections.sort(availables, (o1, o2) -> {
            if (o1 != null && o2 != null) {
                return o1.getSimpleName().compareTo(o2.getSimpleName());
            }
            return 0;
        });
        return availables;
    }

    public void setListener(Listener l) {
        this.listener = l;
    }

    public static interface Listener {
        public void registered(TopProcessMetaModel var1);
    }
}

