/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.utils;

import ch.sharedvd.tipi.engine.utils.Assert;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ArrayLong
implements Serializable,
Iterable<Long> {
    private static final long serialVersionUID = 6843092778934655429L;
    private long[] array;
    private int first;
    private int last;

    public ArrayLong() {
        this((long[])null);
    }

    public ArrayLong(Collection<Long> list) {
        if (list != null && list.size() > 0) {
            this.array = ArrayLong.list2array(list);
            this.first = 0;
            this.last = this.array.length - 1;
        } else {
            this.array = null;
        }
    }

    public ArrayLong(long ... aArray) {
        if (aArray != null && aArray.length > 0) {
            this.array = aArray;
            this.first = 0;
            this.last = aArray.length - 1;
        } else {
            this.array = null;
        }
    }

    public ArrayLong(ArrayLong array, int first, int last) {
        this(array.array, first, last);
    }

    public ArrayLong(long[] array, int first, int last) {
        if (array != null) {
            Assert.isTrue((array.length > 0 ? 1 : 0) != 0);
            Assert.isTrue((first >= 0 ? 1 : 0) != 0);
            Assert.isTrue((last >= 0 ? 1 : 0) != 0);
            Assert.isTrue((first <= last ? 1 : 0) != 0);
            Assert.isTrue((last < array.length ? 1 : 0) != 0);
            Assert.isTrue((array.length >= last - first + 1 ? 1 : 0) != 0);
            this.array = array;
            this.first = first;
            this.last = last;
        } else {
            this.array = null;
        }
    }

    public ArrayLong(int ... aArray) {
        if (aArray != null && aArray.length > 0) {
            this.array = new long[aArray.length];
            for (int i = 0; i < aArray.length; ++i) {
                this.array[i] = aArray[i];
            }
            this.first = 0;
            this.last = aArray.length - 1;
        } else {
            this.array = null;
        }
    }

    public int size() {
        if (this.array != null) {
            int s = this.last - this.first + 1;
            return s;
        }
        return 0;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public long get(int index) {
        Assert.isTrue((index >= 0 && index < this.size() ? 1 : 0) != 0);
        return this.array[this.first + index];
    }

    public List<ArrayLong> splitByMax(int max) {
        ArrayList<ArrayLong> list = new ArrayList<ArrayLong>();
        int s = this.size();
        for (int index = 0; index < s; index += max) {
            int last = index + max - 1;
            if (last >= s) {
                last = s - 1;
            }
            ArrayLong arr = new ArrayLong(this.array, index + this.first, last + this.first);
            list.add(arr);
        }
        return list;
    }

    public List<ArrayLong> splitInLists(int nbLists) {
        Assert.isTrue((nbLists > 0 ? 1 : 0) != 0);
        double max = (float)this.size() / 1.0f / (float)nbLists;
        int m = (int)Math.ceil(max);
        return this.splitByMax(m);
    }

    public List<Long> toList() {
        if (this.array != null) {
            ArrayList<Long> list = new ArrayList<Long>();
            for (int i = 0; i < this.size(); ++i) {
                list.add(this.get(i));
            }
            return list;
        }
        return null;
    }

    public List<Integer> toIntegerList() {
        if (this.array != null) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int i = 0; i < this.size(); ++i) {
                list.add((int)this.get(i));
            }
            return list;
        }
        return null;
    }

    public long[] toArray() {
        if (this.array != null) {
            long[] arr = new long[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                arr[i] = this.get(i);
            }
            return arr;
        }
        return null;
    }

    public Long[] toLongArray() {
        if (this.array != null) {
            Long[] arr = new Long[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                arr[i] = this.get(i);
            }
            return arr;
        }
        return null;
    }

    private static long[] list2array(Collection<Long> list) {
        Assert.notNull(list);
        Assert.notEmpty(list);
        long[] array = new long[list.size()];
        int index = 0;
        for (Long v : list) {
            array[index] = v;
            ++index;
        }
        return array;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        Iterator<Long> i = this.iterator();
        while (i.hasNext()) {
            if (!first) {
                sb.append(" ");
            }
            sb.append(i.next());
            first = false;
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Iterator<Long> iterator() {
        return new ArrayLongIterator();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int len;
        long[] altow = this.array;
        if (null != this.array && (len = this.last - this.first + 1) < this.array.length) {
            altow = new long[len];
            System.arraycopy(this.array, this.first, altow, 0, len);
        }
        out.writeObject(altow);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.array = (long[])in.readObject();
        if (null != this.array) {
            this.first = 0;
            this.last = this.array.length - 1;
        }
    }

    public class ArrayLongIterator
    implements Iterator<Long> {
        public int index = 0;

        @Override
        public boolean hasNext() {
            return this.index < ArrayLong.this.size();
        }

        @Override
        public Long next() {
            return ArrayLong.this.get(this.index++);
        }

        @Override
        public void remove() {
            Assert.fail("Not supported");
        }
    }
}

