/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.command;

import ch.sharedvd.tipi.engine.command.Command;
import ch.sharedvd.tipi.engine.command.CommandConsumer;
import ch.sharedvd.tipi.engine.command.CommandService;
import ch.sharedvd.tipi.engine.utils.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class CommandServiceImpl
implements CommandService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandServiceImpl.class);
    @Autowired
    private CommandConsumer consumer;

    @Override
    public void removeCommandOfClass(Class<? extends Command> clazz) {
        this.consumer.removeCommandOfClass(clazz);
    }

    @Override
    public void sendCommand(Command command) {
        Assert.notNull((Object)command);
        try {
            if (TransactionSynchronizationManager.isSynchronizationActive()) {
                CommandSynchronization synchro = new CommandSynchronization(command);
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)synchro);
            } else {
                this.consumer.addCommand(command);
            }
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private class CommandSynchronization
    implements TransactionSynchronization {
        private final Command command;

        CommandSynchronization(Command c) {
            Assert.notNull((Object)c, (String)"Command can't be null");
            this.command = c;
        }

        public void suspend() {
        }

        public void resume() {
        }

        public void flush() {
            this.toString();
        }

        public void beforeCommit(boolean readOnly) {
            this.toString();
        }

        public void beforeCompletion() {
            this.toString();
        }

        public void afterCommit() {
            this.toString();
        }

        public void afterCompletion(int status) {
            if (0 == status) {
                CommandServiceImpl.this.consumer.addCommand(this.command);
            }
        }
    }
}

