/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.meta;

import ch.sharedvd.tipi.engine.action.TopProcess;
import ch.sharedvd.tipi.engine.client.TipiTopProcess;
import ch.sharedvd.tipi.engine.meta.SubProcessMetaModel;
import ch.sharedvd.tipi.engine.meta.VariableDescription;
import java.util.Arrays;
import org.springframework.util.Assert;

public class TopProcessMetaModel
extends SubProcessMetaModel {
    private static final long serialVersionUID = 1L;
    private Boolean startable;
    private Boolean deleteWhenFinished;
    private Boolean isShownInUI;
    private final int priority;
    private final int nbMaxTopConcurrent;
    private final int nbMaxConcurrent;

    public TopProcessMetaModel(Class<?> clazz, int priority, int nbMaxConcurrent, String descr) {
        this(clazz, null, null, priority, Integer.MAX_VALUE, nbMaxConcurrent, descr, false);
    }

    public TopProcessMetaModel(Class<?> clazz, int priority, int nbMaxTopConcurrent, int nbMaxConcurrent, String descr) {
        this(clazz, null, null, priority, nbMaxTopConcurrent, nbMaxConcurrent, descr, false);
    }

    public TopProcessMetaModel(Class<?> clazz, VariableDescription[] variables, TipiTopProcess ann) {
        this(clazz, variables, null, ann);
    }

    public TopProcessMetaModel(Class<?> clazz, VariableDescription[] vars, String[] usedConnections, TipiTopProcess ann) {
        this(clazz, vars, usedConnections, ann.priority(), ann.nbMaxTopConcurrent(), ann.nbMaxConcurrent(), ann.description(), false);
    }

    public TopProcessMetaModel(Class<?> clazz, VariableDescription[] vars, String[] usedConnections, int priority, int nbMaxTopConcurrent, int nbMaxConcurrent, String descr, boolean showInUI) {
        super(clazz, vars != null ? Arrays.asList(vars) : null, usedConnections, descr);
        this.isShownInUI = showInUI;
        this.priority = priority;
        this.nbMaxTopConcurrent = nbMaxTopConcurrent;
        this.nbMaxConcurrent = nbMaxConcurrent;
        Assert.isTrue((boolean)TopProcess.class.isAssignableFrom(clazz));
    }

    public boolean isShownInUI() {
        return this.isShownInUI == null || this.isShownInUI != false;
    }

    void setShownInUI(Boolean shownInUI) {
        this.isShownInUI = shownInUI;
    }

    public boolean isStartable() {
        return this.startable == null || this.startable != false;
    }

    void setStartable(boolean startable) {
        this.startable = startable;
    }

    public boolean isDeleteWhenFinished() {
        return this.deleteWhenFinished == null || this.deleteWhenFinished != false;
    }

    public void setDeleteWhenFinished(boolean deleteWhenFinished) {
        this.deleteWhenFinished = deleteWhenFinished;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getNbMaxTopConcurrent() {
        return this.nbMaxTopConcurrent;
    }

    public int getNbMaxConcurrent() {
        return this.nbMaxConcurrent;
    }
}

