/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.model;

import ch.sharedvd.tipi.engine.model.DbVariable;
import ch.sharedvd.tipi.engine.utils.BlobFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DiscriminatorValue(value="serializable")
public class DbSerializableVariable
extends DbVariable<Serializable> {
    private static final long serialVersionUID = -7115434484742577133L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DbSerializableVariable.class);
    private Blob blob;
    private transient Serializable deserialBlob = null;

    protected DbSerializableVariable() {
    }

    public DbSerializableVariable(String key, Serializable value, BlobFactory aBlobFactory) {
        super(key);
        this.setValue(value, aBlobFactory);
    }

    @Column(name="BLOB_VALUE")
    public Blob getBlob() {
        return this.blob;
    }

    public void setBlob(Blob b) {
        this.blob = b;
    }

    @Override
    @Transient
    public Serializable getValue() {
        if (this.deserialBlob == null) {
            if (this.getBlob() != null) {
                InputStream bis = null;
                InflaterInputStream iis = null;
                ObjectInputStream ois = null;
                try {
                    if (this.getBlob().length() > 0L) {
                        Serializable serial;
                        bis = this.getBlob().getBinaryStream();
                        iis = new InflaterInputStream(bis);
                        ois = new ObjectInputStream(iis);
                        this.deserialBlob = serial = (Serializable)ois.readObject();
                        return this.deserialBlob;
                    }
                }
                catch (Exception e) {
                    IOUtils.closeQuietly(bis);
                    IOUtils.closeQuietly(iis);
                    IOUtils.closeQuietly(ois);
                    String msg = "Impossible de lire le blob";
                    throw new RuntimeException(msg, e);
                }
            }
            return null;
        }
        return this.deserialBlob;
    }

    public void setValue(Serializable serial, BlobFactory aBlobFactory) {
        this.deserialBlob = null;
        ByteArrayOutputStream bos = null;
        DeflaterOutputStream dos = null;
        ObjectOutputStream oos = null;
        try {
            bos = new ByteArrayOutputStream();
            dos = new DeflaterOutputStream(bos);
            oos = new ObjectOutputStream(dos);
            oos.writeObject(serial);
            oos.close();
            this.setBlob(aBlobFactory.createBlob(bos.toByteArray()));
        }
        catch (IOException e) {
            try {
                String msg = "Impossible de mettre \u00e0 jour le blob";
                throw new RuntimeException(msg, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((OutputStream)bos);
                IOUtils.closeQuietly(dos);
                IOUtils.closeQuietly(oos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)bos);
        IOUtils.closeQuietly((OutputStream)dos);
        IOUtils.closeQuietly((OutputStream)oos);
    }
}

