/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.runner;

import ch.sharedvd.tipi.engine.action.TopProcess;
import ch.sharedvd.tipi.engine.client.VariableMap;
import ch.sharedvd.tipi.engine.command.CommandService;
import ch.sharedvd.tipi.engine.command.impl.ResumeActivityCommand;
import ch.sharedvd.tipi.engine.command.impl.ResumeAllActivitiesCommand;
import ch.sharedvd.tipi.engine.command.impl.RunExecutingActivitiesCommand;
import ch.sharedvd.tipi.engine.meta.ActivityMetaModel;
import ch.sharedvd.tipi.engine.meta.MetaModelHelper;
import ch.sharedvd.tipi.engine.meta.TopProcessMetaModel;
import ch.sharedvd.tipi.engine.model.ActivityState;
import ch.sharedvd.tipi.engine.model.DbActivity;
import ch.sharedvd.tipi.engine.model.DbTopProcess;
import ch.sharedvd.tipi.engine.repository.ActivityRepository;
import ch.sharedvd.tipi.engine.repository.TopProcessRepository;
import ch.sharedvd.tipi.engine.runner.ActivityStateChangeService;
import ch.sharedvd.tipi.engine.runner.ConnectionCapManager;
import ch.sharedvd.tipi.engine.runner.ProcessDeleter;
import ch.sharedvd.tipi.engine.runner.TopProcessGroupLauncher;
import ch.sharedvd.tipi.engine.runner.TopProcessGroupManager;
import ch.sharedvd.tipi.engine.svc.ActivityPersisterService;
import ch.sharedvd.tipi.engine.utils.Assert;
import ch.sharedvd.tipi.engine.utils.TixTemplate;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ActivityRunningService {
    private Logger LOGGER = LoggerFactory.getLogger(ActivityRunningService.class);
    @Autowired
    private TopProcessGroupManager topProcessGroupManager;
    @Autowired
    private ConnectionCapManager connectionCapManager;
    @Autowired
    private ActivityPersisterService activityPersistenceService;
    @Autowired
    private CommandService commandService;
    @Autowired
    private ActivityRepository activityRepository;
    @Autowired
    private TopProcessRepository topProcessRepository;
    @Autowired
    private EntityManager em;
    @Autowired
    private TixTemplate txTemplate;

    public List<String> getTopProcessNamesWithExecutingActivities() {
        return this.activityRepository.findTopProcessNamesByStateAndReqEnd(ActivityState.EXECUTING);
    }

    List<DbActivity> getExecutingActivities(String aTopProcessName, Collection<Long> aRunningActivities, int max) {
        List<DbActivity> execs = this.activityRepository.findExecutingActivities(aTopProcessName);
        List<DbActivity> execsNotRunning = execs.stream().filter(a -> !aRunningActivities.contains(a.getId())).collect(Collectors.toList());
        return execsNotRunning;
    }

    public long launch(ActivityMetaModel meta, VariableMap vars) {
        long id = this.txTemplate.txWith(s -> {
            Assert.notNull((Object)meta);
            Assert.notNull((Object)meta, (String)("Meta not found: " + meta));
            return this.launch(this.activityRepository, meta, vars);
        });
        return id;
    }

    public long launch(Class<? extends TopProcess> cls, VariableMap vars) {
        long id = this.txTemplate.txWith(status -> {
            TopProcessMetaModel meta = MetaModelHelper.createTopProcessMetaModel(cls);
            Assert.notNull((Object)meta);
            Assert.notNull((Object)meta, (String)("Meta not found: " + meta));
            return this.launch(this.activityRepository, meta, vars);
        });
        return id;
    }

    public long launch(ActivityRepository activityRepository, ActivityMetaModel meta, VariableMap vars) {
        activityRepository.findOne(Long.valueOf(1L));
        Assert.notNull((Object)meta);
        DbActivity model = this.activityPersistenceService.persistModelFromMeta(meta, true, vars);
        ActivityStateChangeService.executingFirstActivity(model);
        model.setDateStartExecute(new Date());
        this.commandService.sendCommand(new RunExecutingActivitiesCommand());
        return model.getId();
    }

    public void resumeAllError() {
        this.commandService.sendCommand(new ResumeAllActivitiesCommand(ActivityState.ERROR));
    }

    public void resumeErrors(String groupName) {
        this.commandService.sendCommand(new ResumeAllActivitiesCommand(ActivityState.ERROR, groupName));
    }

    public void resumeAllSuspended() {
        this.commandService.sendCommand(new ResumeAllActivitiesCommand(ActivityState.SUSPENDED));
    }

    public boolean isResumable(long id) {
        return this.txTemplate.txWith(status -> {
            DbActivity activity = (DbActivity)this.activityRepository.findOne(Long.valueOf(id));
            return null != activity && activity.isResumable();
        });
    }

    public void resume(long id, VariableMap vars) {
        this.txTemplate.txWithout(status -> {
            DbActivity aActivity = (DbActivity)this.activityRepository.findOne(Long.valueOf(id));
            if (vars != null) {
                ActivityMetaModel meta = MetaModelHelper.createActivityMetaModel(aActivity.getFqn());
                for (String key : vars.keySet()) {
                    this.activityPersistenceService.putVariable(aActivity, meta, key, vars.get(key));
                }
            }
            this.commandService.sendCommand(new ResumeActivityCommand(id, vars));
        });
    }

    public boolean isRunning(long aid) {
        return this.txTemplate.txWith(status -> {
            DbActivity act = (DbActivity)this.activityRepository.findOne(Long.valueOf(aid));
            return act != null && !act.isTerminated() && !act.isAborted() && !act.isTerminatedWithError() && !act.isTerminatedSuspended();
        });
    }

    public boolean isProcessRunning(long id) {
        return this.txTemplate.txWith(status -> {
            DbActivity act = (DbActivity)this.activityRepository.findOne(Long.valueOf(id));
            return null != act && this.isRunning(act.getProcessOrThis().getId());
        });
    }

    public boolean isProcessScheduled(long aid) {
        return this.txTemplate.txWith(status -> {
            DbActivity act = (DbActivity)this.activityRepository.findOne(Long.valueOf(aid));
            if (act == null) {
                return false;
            }
            if (act.isTerminated() || act.isAborted() || act.isTerminatedWithError() || act.isTerminatedSuspended()) {
                return false;
            }
            TopProcessGroupLauncher launcher = this.topProcessGroupManager.getLauncher(act.getProcessOrThis().getFqn());
            return launcher.isRunning(aid);
        });
    }

    public boolean deleteProcess(long processId) {
        return this.txTemplate.txWith(status -> {
            DbActivity model = (DbActivity)this.activityRepository.findOne(Long.valueOf(processId));
            if (null != model && model instanceof DbTopProcess) {
                return this.deleteProcess((DbTopProcess)model);
            }
            return Boolean.TRUE;
        });
    }

    public boolean deleteProcess(DbTopProcess process) {
        ProcessDeleter deleter = new ProcessDeleter(process, this.em, this.topProcessRepository);
        return deleter.delete();
    }

    public void abortProcess(long processId) {
        this.txTemplate.txWithout(status -> {
            this.LOGGER.info("Aborting process " + processId);
            DbActivity act = (DbActivity)this.topProcessRepository.findOne(Long.valueOf(processId));
            this.LOGGER.debug("Process " + act.getId() + "/" + act.getFqn() + " -> state=ABORTED");
            act.setState(ActivityState.ABORTED);
        });
        this.LOGGER.info("Aborting process " + processId + " sub-processess");
        this.txTemplate.txWithout(status -> {
            this.LOGGER.debug("Activities of process " + processId + " -> state=ABORTED");
            Query q = this.em.createQuery("update DbActivity a set a.state = 'ABORTED' where a.process.id = :processId");
            q.setParameter("processId", (Object)processId);
            q.executeUpdate();
        });
    }

    public void setMaxConnections(String aConnectionType, int aNbMaxConnections) {
        this.connectionCapManager.setNbMaxConcurrent(aConnectionType, aNbMaxConnections);
        this.commandService.sendCommand(new RunExecutingActivitiesCommand());
    }

    public void setMaxConcurrentActivitiesForGroup(String aGroupName, int aNbMaxConnections) {
        this.topProcessGroupManager.setMaxConcurrentActivitiesForGroup(aGroupName, aNbMaxConnections);
        this.commandService.sendCommand(new RunExecutingActivitiesCommand());
    }

    public void setPriorityForGroup(String aGroupName, int aPrio) {
        this.topProcessGroupManager.setPriorityForGroup(aGroupName, aPrio);
        this.commandService.sendCommand(new RunExecutingActivitiesCommand());
    }
}

