/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.runner;

import ch.sharedvd.tipi.engine.command.CommandConsumer;
import ch.sharedvd.tipi.engine.runner.ConnectionCapManager;
import ch.sharedvd.tipi.engine.runner.Startable;
import ch.sharedvd.tipi.engine.runner.TipiStarter;
import ch.sharedvd.tipi.engine.runner.TopProcessGroupManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.util.Assert;

public class TipiStarterImpl
implements TipiStarter,
Startable,
InitializingBean,
DisposableBean,
ApplicationContextAware,
ApplicationListener<ApplicationEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TipiStarterImpl.class);
    @Autowired
    private TopProcessGroupManager topProcessGroupManager;
    @Autowired
    private CommandConsumer commandConsumer;
    @Autowired
    protected ConnectionCapManager connectionCapManager;
    private ApplicationContext applicationContext;
    private Boolean startAtBoot;
    private boolean alreadyStartedBySpring = false;

    public void onApplicationEvent(ApplicationEvent applicationEvent) {
        if (!this.alreadyStartedBySpring && applicationEvent instanceof ContextRefreshedEvent && ((ContextRefreshedEvent)applicationEvent).getApplicationContext() == this.applicationContext && (this.startAtBoot == null || this.startAtBoot.booleanValue())) {
            boolean pauseGroups = false;
            String value = System.getProperty("tipi.pause");
            if (value != null && "true".equals(value)) {
                pauseGroups = true;
                LOGGER.warn("TiPi d\u00e9marr\u00e9 en mode pause (-Dtipi.pause=true)");
            } else {
                LOGGER.debug("TiPi d\u00e9marr\u00e9 normalement (-Dtipi.pause=false)");
            }
            try {
                this.start(pauseGroups);
                this.alreadyStartedBySpring = true;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.checkJvmVersion();
    }

    private void checkJvmVersion() {
        int cmp;
        String version = System.getProperty("java.version");
        if (version.startsWith("1.6") && (cmp = version.compareTo("1.6.0_30")) < 0) {
            LOGGER.error("Mauvaise version de la JVM " + version + " : incompatible avec TiPi (version minimale: 1.6.0_30)");
            Assert.isTrue((cmp >= 0 ? 1 : 0) != 0, (String)("Mauvaise version de la JVM: " + version));
        }
        LOGGER.info("Version de la JVM " + version + " compatible avec TiPi (version minimale: 1.6.0_30)");
    }

    @Override
    public void destroy() throws Exception {
        LOGGER.info("Destroying TiPi");
        this.commandConsumer.destroy();
        this.topProcessGroupManager.destroy();
    }

    @Override
    public boolean isStarted() throws Exception {
        return !this.commandConsumer.isStopped();
    }

    @Override
    public void start() throws Exception {
        this.start(false);
    }

    public void start(boolean pauseGroups) throws Exception {
        LOGGER.info("Starting TiPi ...");
        this.topProcessGroupManager.start();
        this.commandConsumer.start();
        LOGGER.info("TiPi started and ready to execute.");
    }

    @Override
    public void stop() throws Exception {
        LOGGER.info("Stopping TiPi ...");
        this.topProcessGroupManager.stop();
        this.commandConsumer.destroy();
    }

    public void setStartAtBoot(Boolean startAtBoot) {
        this.startAtBoot = startAtBoot;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

