/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import org.apache.commons.io.IOUtils;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.engine.jdbc.LobCreator;

public class BlobFactory {
    private Session session;

    public BlobFactory(Session session) {
        this.session = session;
    }

    public Blob createBlob(byte[] aBytes) {
        return Hibernate.getLobCreator((Session)this.session).createBlob(aBytes);
    }

    public Blob createBlob(InputStream aInputStream) {
        LobCreator lobCreator = Hibernate.getLobCreator((Session)this.session);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)aInputStream, (OutputStream)bos);
            return lobCreator.createBlob((InputStream)new ByteArrayInputStream(bos.toByteArray()), (long)bos.size());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public Blob createBlob(InputStream aInputStream, long aLength) {
        return Hibernate.getLobCreator((Session)this.session).createBlob(aInputStream, aLength);
    }
}

