/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.action;

import ch.sharedvd.tipi.engine.action.AbortManagerImpl;
import ch.sharedvd.tipi.engine.action.ActivityException;
import ch.sharedvd.tipi.engine.action.ActivityFacade;
import ch.sharedvd.tipi.engine.action.ActivityResultContext;
import ch.sharedvd.tipi.engine.action.ErrorActivityResultContext;
import ch.sharedvd.tipi.engine.client.AbortManager;
import ch.sharedvd.tipi.engine.utils.ArrayLong;
import ch.sharedvd.tipi.engine.utils.InputStreamHolder;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Activity {
    private static final Logger LOGGER = LoggerFactory.getLogger(Activity.class);
    protected ActivityFacade facade;

    protected Activity() {
    }

    protected Activity(ActivityFacade facade) {
        this.facade = facade;
    }

    protected abstract ActivityResultContext execute() throws Exception;

    protected void begin() throws Exception {
    }

    protected void end() throws Exception {
    }

    public final ActivityResultContext doExecute() throws Exception {
        ActivityResultContext resultContext;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing activity: " + this.facade.getId() + ". Nom: " + this.facade.getName() + ". ");
        }
        try {
            this.begin();
            resultContext = this.execute();
        }
        catch (ActivityException e) {
            resultContext = new ErrorActivityResultContext("Type: " + e.getClass().getName() + ". Message: " + e.getMessage());
        }
        finally {
            try {
                this.end();
            }
            catch (Throwable t) {
                LOGGER.error("La m\u00e9thode end() a renvoy\u00e9 une exception!", t);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finishing activity: " + this.facade.getId() + ". Nom: " + this.facade.getName() + ". ");
        }
        return resultContext;
    }

    public void onError(Throwable exception) {
    }

    public void onAfterCommit() {
    }

    public void testAbort() {
        this.getAbortManager().testAbort();
    }

    public long getActivityId() {
        return this.facade.getId();
    }

    public List<ActivityFacade> getChildren() {
        return this.facade.getChildren();
    }

    protected Object getVariable(String name) {
        return this.facade.getVariable(name);
    }

    protected LocalDate getLocalDateVariable(String name) {
        Integer i = (Integer)this.facade.getVariable(name);
        if (i != null) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
            formatter = formatter.withLocale(Locale.FRENCH);
            LocalDate date = LocalDate.parse("" + i, formatter);
            return date;
        }
        return null;
    }

    protected InputStream getInputStreamVariable(String name) {
        InputStreamHolder variable = (InputStreamHolder)this.facade.getVariable(name);
        return variable.getInputStream();
    }

    protected Integer getIntVariable(String name) {
        return (Integer)this.facade.getVariable(name);
    }

    protected String getStringVariable(String name) {
        return (String)this.facade.getVariable(name);
    }

    protected Boolean getBooleanVariable(String name) {
        return (Boolean)this.facade.getVariable(name);
    }

    protected Long getLongVariable(String name) {
        return (Long)this.facade.getVariable(name);
    }

    protected ArrayLong getArrayLongVariable(String name) {
        return (ArrayLong)this.facade.getVariable(name);
    }

    protected Integer getIntVariable(long id, String name) {
        return (Integer)this.facade.getVariable(id, name);
    }

    protected String getStringVariable(long id, String name) {
        return (String)this.facade.getVariable(id, name);
    }

    protected Long getLongVariable(long id, String name) {
        return (Long)this.facade.getVariable(id, name);
    }

    protected void putVariable(String key, Serializable value) {
        this.facade.putVariable(key, value);
    }

    public void setFacade(ActivityFacade facade) {
        this.facade = facade;
    }

    protected AbortManager getAbortManager() {
        AbortManagerImpl abort = new AbortManagerImpl(this.facade);
        return abort;
    }
}

