/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.command.impl;

import ch.sharedvd.tipi.engine.client.VariableMap;
import ch.sharedvd.tipi.engine.command.impl.ActivityCommand;
import ch.sharedvd.tipi.engine.model.DbActivity;
import ch.sharedvd.tipi.engine.runner.ActivityStateChangeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResumeActivityCommand
extends ActivityCommand {
    private Logger LOGGER = LoggerFactory.getLogger(ResumeActivityCommand.class);
    private VariableMap vars;

    public ResumeActivityCommand(long id, VariableMap vars) {
        super(id);
        this.vars = vars;
    }

    public VariableMap getVars() {
        return this.vars;
    }

    @Override
    public void execute() {
        DbActivity aActivity = this.getModel();
        boolean isRes = aActivity.isResumable();
        if (isRes) {
            ActivityStateChangeService.resuming(aActivity);
            this.LOGGER.info("Resuming activity " + aActivity.getId() + " / " + aActivity.getFqn());
            this.runActivity();
        } else {
            this.LOGGER.info("Activity " + aActivity.getId() + " is not in a resumable state (" + (Object)((Object)aActivity.getState()) + ")");
        }
    }
}

