/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.infos;

import ch.sharedvd.tipi.engine.runner.stats.TipiThreadStats;
import java.io.Serializable;
import java.util.Date;

public class ActivityThreadInfos
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long threadId;
    private String threadName;
    private Long activityId;
    private String activityName;
    private boolean running;
    private String status;
    private Date startTime;

    public ActivityThreadInfos(TipiThreadStats s) {
        this.threadId = s.getId();
        this.threadName = s.getName();
        this.activityId = s.getActivityId();
        this.activityName = s.getActivityName();
        this.running = s.isRunning();
        this.status = s.getStatus();
        this.startTime = s.getStartTime();
    }

    public Long getThreadId() {
        return this.threadId;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public Long getActivityId() {
        return this.activityId;
    }

    public String getActivityName() {
        return this.activityName;
    }

    public boolean isRunning() {
        return this.running;
    }

    public String getStatus() {
        if (this.isRunning()) {
            Date now = new Date();
            long diff = now.getTime() - this.startTime.getTime();
            return String.format("%s : %d[s]", this.status, (int)((double)diff / 1000.0));
        }
        return this.status;
    }
}

