/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.meta;

import ch.sharedvd.tipi.engine.action.Activity;
import ch.sharedvd.tipi.engine.action.SubProcess;
import ch.sharedvd.tipi.engine.action.TopProcess;
import ch.sharedvd.tipi.engine.meta.SubProcessMetaModel;
import ch.sharedvd.tipi.engine.meta.TopProcessMetaModel;
import ch.sharedvd.tipi.engine.meta.VariableDescription;
import ch.sharedvd.tipi.engine.utils.Assert;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ActivityMetaModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<?> clazz;
    private final Set<String> usedConnections = new HashSet<String>();
    private String description;
    private List<VariableDescription> variablesDescription = null;

    public ActivityMetaModel(Class<?> clazz) {
        this(clazz, null, null, null);
    }

    public ActivityMetaModel(Class<?> clazz, VariableDescription[] variables) {
        this(clazz, Arrays.asList(variables), null, null);
    }

    public ActivityMetaModel(Class<?> clazz, String descr) {
        this(clazz, null, null, descr);
    }

    public ActivityMetaModel(Class<?> clazz, String[] aUsedConnections, String descr) {
        this(clazz, null, aUsedConnections, descr);
    }

    public ActivityMetaModel(Class<?> clazz, List<VariableDescription> variables, String[] aUsedConnections, String descr) {
        Assert.notNull(clazz);
        Assert.isTrue((boolean)Activity.class.isAssignableFrom(clazz));
        this.clazz = clazz;
        this.description = descr;
        this.variablesDescription = variables;
        if (null != aUsedConnections) {
            for (String ct : aUsedConnections) {
                this.usedConnections.add(ct);
            }
        }
        this.init();
        Assert.isTrue((boolean)Activity.class.isAssignableFrom(clazz));
        if (this instanceof TopProcessMetaModel) {
            Assert.isTrue((boolean)TopProcess.class.isAssignableFrom(clazz), (String)("Class " + clazz + " n'est pas un Processus"));
        } else if (this instanceof SubProcessMetaModel) {
            Assert.isTrue((boolean)SubProcess.class.isAssignableFrom(clazz), (String)("Class " + clazz + " n'est pas un SubProcess"));
            Assert.isFalse(TopProcess.class.isAssignableFrom(clazz), "Class " + clazz + " est un Processus");
        } else {
            Assert.isFalse(SubProcess.class.isAssignableFrom(clazz), "Class " + clazz + " est un SubProcess");
        }
    }

    protected void init() {
    }

    public List<VariableDescription> getVariables() {
        return this.variablesDescription;
    }

    public VariableDescription getVariable(String key) {
        if (this.variablesDescription != null) {
            return this.variablesDescription.stream().filter(vd -> vd.getName().equals(key)).findFirst().orElse(null);
        }
        return null;
    }

    public String getFQN() {
        return this.clazz.getName();
    }

    public Set<String> getUsedConnections() {
        return this.usedConnections;
    }

    public String getDescription() {
        return this.description;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public String getSimpleName() {
        return this.clazz.getSimpleName();
    }

    public Activity create() {
        try {
            return (Activity)this.clazz.newInstance();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

