/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.model;

import ch.sharedvd.tipi.engine.model.DbBlobVariable;
import ch.sharedvd.tipi.engine.model.DbSerializableVariable;
import ch.sharedvd.tipi.engine.utils.BlobFactory;
import ch.sharedvd.tipi.engine.utils.InputStreamHolder;
import java.io.InputStream;
import java.util.zip.DeflaterInputStream;
import java.util.zip.InflaterInputStream;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DiscriminatorValue(value="file")
public class DbInputStreamVariable
extends DbBlobVariable<InputStreamHolder> {
    private static final long serialVersionUID = -9135399754284748931L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DbSerializableVariable.class);
    private transient InputStreamHolder deserialBlob = null;

    protected DbInputStreamVariable() {
    }

    public DbInputStreamVariable(String key, InputStreamHolder value, BlobFactory aBlobFactory) {
        super(key);
        this.setValue(value, aBlobFactory);
    }

    @Override
    @Transient
    public InputStreamHolder getValue() {
        if (this.deserialBlob == null) {
            if (this.getBlob() != null) {
                InflaterInputStream inputStream = null;
                InputStream binaryStream = null;
                try {
                    if (this.getBlob().length() > 0L) {
                        binaryStream = this.getBlob().getBinaryStream();
                        inputStream = new InflaterInputStream(binaryStream);
                        this.deserialBlob = new InputStreamHolder(inputStream);
                        return this.deserialBlob;
                    }
                }
                catch (Exception e) {
                    IOUtils.closeQuietly(inputStream);
                    IOUtils.closeQuietly(binaryStream);
                    String msg = "Impossible de lire le blob";
                    throw new RuntimeException(msg, e);
                }
            }
            return null;
        }
        return this.deserialBlob;
    }

    public void setValue(InputStreamHolder is, BlobFactory aBlobFactory) {
        this.deserialBlob = null;
        try (DeflaterInputStream inputStream = new DeflaterInputStream(is.getInputStream());){
            this.setBlob(aBlobFactory.createBlob(inputStream));
        }
        catch (Exception e) {
            String msg = "Impossible de mettre \u00e0 jour le blob";
            throw new RuntimeException(msg, e);
        }
    }
}

