/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.query;

import ch.sharedvd.tipi.engine.utils.ResultListWithCount;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;

public class HqlQuery {
    private final StringBuilder select = new StringBuilder();
    private final StringBuilder from = new StringBuilder();
    private final StringBuilder where = new StringBuilder();
    private final Map<String, Object> params = new HashMap<String, Object>();
    private final StringBuilder order = new StringBuilder();

    public HqlQuery() {
    }

    public HqlQuery(String select, String from) {
        this.select.append(select);
        this.from.append(from);
    }

    public HqlQuery select(String hql) {
        this.select.append(hql);
        return this;
    }

    public HqlQuery from(String hql) {
        this.from.append(hql);
        return this;
    }

    public HqlQuery where(String hql) {
        this.where.append(hql);
        return this;
    }

    public HqlQuery where(String hql, String paramName, Object paramValue) {
        this.where.append(hql);
        this.params.put(paramName, paramValue);
        return this;
    }

    public HqlQuery order(String hql) {
        this.order.append(hql);
        return this;
    }

    private Query createQuery(EntityManager em) {
        Query q = em.createQuery(this.concat(false));
        for (Map.Entry<String, Object> e : this.params.entrySet()) {
            q.setParameter(e.getKey(), e.getValue());
        }
        return q;
    }

    private Query createCountQuery(EntityManager em) {
        Query q = em.createQuery(this.concat(true));
        for (Map.Entry<String, Object> e : this.params.entrySet()) {
            q.setParameter(e.getKey(), e.getValue());
        }
        return q;
    }

    public <T> ResultListWithCount<T> getResultListWithCount(EntityManager em, int maxHits) {
        Query q1 = this.createCountQuery(em);
        long count = (Long)q1.getSingleResult();
        Query q2 = this.createQuery(em);
        if (maxHits > 0) {
            q2.setMaxResults(maxHits);
        }
        List resList = q2.getResultList();
        return new ResultListWithCount(resList, count);
    }

    public <T> List<T> getResultList(EntityManager em) {
        Query q = this.createQuery(em);
        return q.getResultList();
    }

    public <T> T getSingleResult(EntityManager em) {
        Query q = this.createQuery(em);
        return (T)q.getSingleResult();
    }

    private String concat(boolean isForCount) {
        StringBuilder str = new StringBuilder();
        if (isForCount) {
            str.append("select count(*) ");
        } else if (this.select.length() > 0) {
            str.append("select ").append((CharSequence)this.select).append(" ");
        }
        if (this.from.length() > 0) {
            str.append("from ").append((CharSequence)this.from).append(" ");
        }
        if (this.where.length() > 0) {
            str.append("where ").append((CharSequence)this.where).append(" ");
        }
        if (!isForCount && this.order.length() > 0) {
            str.append("order by ").append((CharSequence)this.order);
        }
        return str.toString();
    }
}

