/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.retry;

import ch.sharedvd.tipi.engine.retry.RetryContext;
import ch.sharedvd.tipi.engine.retry.RetryPolicy;
import org.apache.commons.lang3.exception.ExceptionUtils;

public abstract class AbstractRetryPolicy
implements RetryPolicy {
    private static final long serialVersionUID = 1L;

    @Override
    public final boolean canRetry(RetryContext context) {
        Throwable rootException = ExceptionUtils.getRootCause((Throwable)context.getThrowable());
        if (rootException instanceof InterruptedException) {
            return false;
        }
        if (rootException instanceof NullPointerException || rootException instanceof IllegalArgumentException) {
            return context.getRetryCount() < 2L;
        }
        return this.doCanRetry(context);
    }

    public abstract boolean doCanRetry(RetryContext var1);
}

