/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.runner;

import ch.sharedvd.tipi.engine.model.ActivityState;
import ch.sharedvd.tipi.engine.model.DbTopProcess;
import ch.sharedvd.tipi.engine.repository.TopProcessRepository;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessDeleter {
    private static final Logger log = LoggerFactory.getLogger(ProcessDeleter.class);
    private DbTopProcess process;
    private EntityManager em;
    private TopProcessRepository topProcessRepository;

    public ProcessDeleter(DbTopProcess process, EntityManager em, TopProcessRepository r) {
        this.process = process;
        this.em = em;
        this.topProcessRepository = r;
    }

    public boolean delete() {
        long pid = this.process.getId();
        String hql = "select count(*) from DbActivity a where (a.process.id = :pid or a.id = :pid)and a.state = :state";
        Query q = this.em.createQuery("select count(*) from DbActivity a where (a.process.id = :pid or a.id = :pid)and a.state = :state");
        q.setParameter("pid", (Object)pid);
        q.setParameter("state", (Object)ActivityState.EXECUTING);
        int nbActiInExec = q.getFirstResult();
        if (nbActiInExec > 0) {
            log.error("Impossible to delete process " + this.process + ". There are activities in state: EXECUTING");
            return false;
        }
        DbTopProcess p = (DbTopProcess)this.topProcessRepository.findOne(Long.valueOf(pid));
        log.info("Deleting process " + p.getProcessName() + " [id:" + pid + "]");
        this.topProcessRepository.delete(p);
        return true;
    }
}

